/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.simpleemailv2.model.ImportDataSource;

@SdkInternalApi
public class ImportDataSourceMarshaller {
    private static final MarshallingInfo<String> S3URL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("S3Url").build();
    private static final MarshallingInfo<String> DATAFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataFormat").build();
    private static final ImportDataSourceMarshaller instance = new ImportDataSourceMarshaller();

    public static ImportDataSourceMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImportDataSource importDataSource, ProtocolMarshaller protocolMarshaller) {
        if (importDataSource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)importDataSource.getS3Url(), S3URL_BINDING);
            protocolMarshaller.marshall((Object)importDataSource.getDataFormat(), DATAFORMAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

