/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.simpleemailv2.model.transform;

import java.util.List;
import javax.annotation.Generated;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.simpleemailv2.model.*;

import com.amazonaws.protocol.*;
import com.amazonaws.annotation.SdkInternalApi;

/**
 * DkimAttributesMarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
@SdkInternalApi
public class DkimAttributesMarshaller {

    private static final MarshallingInfo<Boolean> SIGNINGENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SigningEnabled").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Status").build();
    private static final MarshallingInfo<List> TOKENS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD)
            .marshallLocationName("Tokens").build();
    private static final MarshallingInfo<String> SIGNINGATTRIBUTESORIGIN_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SigningAttributesOrigin").build();
    private static final MarshallingInfo<String> NEXTSIGNINGKEYLENGTH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextSigningKeyLength").build();
    private static final MarshallingInfo<String> CURRENTSIGNINGKEYLENGTH_BINDING = MarshallingInfo.builder(MarshallingType.STRING)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentSigningKeyLength").build();
    private static final MarshallingInfo<java.util.Date> LASTKEYGENERATIONTIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastKeyGenerationTimestamp").timestampFormat("unixTimestamp").build();

    private static final DkimAttributesMarshaller instance = new DkimAttributesMarshaller();

    public static DkimAttributesMarshaller getInstance() {
        return instance;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(DkimAttributes dkimAttributes, ProtocolMarshaller protocolMarshaller) {

        if (dkimAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {
            protocolMarshaller.marshall(dkimAttributes.getSigningEnabled(), SIGNINGENABLED_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getTokens(), TOKENS_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getSigningAttributesOrigin(), SIGNINGATTRIBUTESORIGIN_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getNextSigningKeyLength(), NEXTSIGNINGKEYLENGTH_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getCurrentSigningKeyLength(), CURRENTSIGNINGKEYLENGTH_BINDING);
            protocolMarshaller.marshall(dkimAttributes.getLastKeyGenerationTimestamp(), LASTKEYGENERATIONTIMESTAMP_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
