/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.signer.model.SigningMaterial;
import com.amazonaws.services.signer.model.SigningProfileStatus;
import com.amazonaws.services.signer.model.transform.SigningProfileMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SigningProfile
implements Serializable,
Cloneable,
StructuredPojo {
    private String profileName;
    private SigningMaterial signingMaterial;
    private String platformId;
    private Map<String, String> signingParameters;
    private String status;
    private String arn;
    private Map<String, String> tags;

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public SigningProfile withProfileName(String profileName) {
        this.setProfileName(profileName);
        return this;
    }

    public void setSigningMaterial(SigningMaterial signingMaterial) {
        this.signingMaterial = signingMaterial;
    }

    public SigningMaterial getSigningMaterial() {
        return this.signingMaterial;
    }

    public SigningProfile withSigningMaterial(SigningMaterial signingMaterial) {
        this.setSigningMaterial(signingMaterial);
        return this;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public SigningProfile withPlatformId(String platformId) {
        this.setPlatformId(platformId);
        return this;
    }

    public Map<String, String> getSigningParameters() {
        return this.signingParameters;
    }

    public void setSigningParameters(Map<String, String> signingParameters) {
        this.signingParameters = signingParameters;
    }

    public SigningProfile withSigningParameters(Map<String, String> signingParameters) {
        this.setSigningParameters(signingParameters);
        return this;
    }

    public SigningProfile addSigningParametersEntry(String key, String value) {
        if (null == this.signingParameters) {
            this.signingParameters = new HashMap<String, String>();
        }
        if (this.signingParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.signingParameters.put(key, value);
        return this;
    }

    public SigningProfile clearSigningParametersEntries() {
        this.signingParameters = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public SigningProfile withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public SigningProfile withStatus(SigningProfileStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public SigningProfile withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public SigningProfile withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public SigningProfile addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public SigningProfile clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfileName() != null) {
            sb.append("ProfileName: ").append(this.getProfileName()).append(",");
        }
        if (this.getSigningMaterial() != null) {
            sb.append("SigningMaterial: ").append(this.getSigningMaterial()).append(",");
        }
        if (this.getPlatformId() != null) {
            sb.append("PlatformId: ").append(this.getPlatformId()).append(",");
        }
        if (this.getSigningParameters() != null) {
            sb.append("SigningParameters: ").append(this.getSigningParameters()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningProfile)) {
            return false;
        }
        SigningProfile other = (SigningProfile)obj;
        if (other.getProfileName() == null ^ this.getProfileName() == null) {
            return false;
        }
        if (other.getProfileName() != null && !other.getProfileName().equals(this.getProfileName())) {
            return false;
        }
        if (other.getSigningMaterial() == null ^ this.getSigningMaterial() == null) {
            return false;
        }
        if (other.getSigningMaterial() != null && !other.getSigningMaterial().equals(this.getSigningMaterial())) {
            return false;
        }
        if (other.getPlatformId() == null ^ this.getPlatformId() == null) {
            return false;
        }
        if (other.getPlatformId() != null && !other.getPlatformId().equals(this.getPlatformId())) {
            return false;
        }
        if (other.getSigningParameters() == null ^ this.getSigningParameters() == null) {
            return false;
        }
        if (other.getSigningParameters() != null && !other.getSigningParameters().equals(this.getSigningParameters())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfileName() == null ? 0 : this.getProfileName().hashCode());
        hashCode = 31 * hashCode + (this.getSigningMaterial() == null ? 0 : this.getSigningMaterial().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformId() == null ? 0 : this.getPlatformId().hashCode());
        hashCode = 31 * hashCode + (this.getSigningParameters() == null ? 0 : this.getSigningParameters().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public SigningProfile clone() {
        try {
            return (SigningProfile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SigningProfileMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

