/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GetRevocationStatusRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Date signatureTimestamp;
    private String platformId;
    private String profileVersionArn;
    private String jobArn;
    private List<String> certificateHashes;

    public void setSignatureTimestamp(Date signatureTimestamp) {
        this.signatureTimestamp = signatureTimestamp;
    }

    public Date getSignatureTimestamp() {
        return this.signatureTimestamp;
    }

    public GetRevocationStatusRequest withSignatureTimestamp(Date signatureTimestamp) {
        this.setSignatureTimestamp(signatureTimestamp);
        return this;
    }

    public void setPlatformId(String platformId) {
        this.platformId = platformId;
    }

    public String getPlatformId() {
        return this.platformId;
    }

    public GetRevocationStatusRequest withPlatformId(String platformId) {
        this.setPlatformId(platformId);
        return this;
    }

    public void setProfileVersionArn(String profileVersionArn) {
        this.profileVersionArn = profileVersionArn;
    }

    public String getProfileVersionArn() {
        return this.profileVersionArn;
    }

    public GetRevocationStatusRequest withProfileVersionArn(String profileVersionArn) {
        this.setProfileVersionArn(profileVersionArn);
        return this;
    }

    public void setJobArn(String jobArn) {
        this.jobArn = jobArn;
    }

    public String getJobArn() {
        return this.jobArn;
    }

    public GetRevocationStatusRequest withJobArn(String jobArn) {
        this.setJobArn(jobArn);
        return this;
    }

    public List<String> getCertificateHashes() {
        return this.certificateHashes;
    }

    public void setCertificateHashes(Collection<String> certificateHashes) {
        if (certificateHashes == null) {
            this.certificateHashes = null;
            return;
        }
        this.certificateHashes = new ArrayList<String>(certificateHashes);
    }

    public GetRevocationStatusRequest withCertificateHashes(String ... certificateHashes) {
        if (this.certificateHashes == null) {
            this.setCertificateHashes(new ArrayList<String>(certificateHashes.length));
        }
        for (String ele : certificateHashes) {
            this.certificateHashes.add(ele);
        }
        return this;
    }

    public GetRevocationStatusRequest withCertificateHashes(Collection<String> certificateHashes) {
        this.setCertificateHashes(certificateHashes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSignatureTimestamp() != null) {
            sb.append("SignatureTimestamp: ").append(this.getSignatureTimestamp()).append(",");
        }
        if (this.getPlatformId() != null) {
            sb.append("PlatformId: ").append(this.getPlatformId()).append(",");
        }
        if (this.getProfileVersionArn() != null) {
            sb.append("ProfileVersionArn: ").append(this.getProfileVersionArn()).append(",");
        }
        if (this.getJobArn() != null) {
            sb.append("JobArn: ").append(this.getJobArn()).append(",");
        }
        if (this.getCertificateHashes() != null) {
            sb.append("CertificateHashes: ").append(this.getCertificateHashes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRevocationStatusRequest)) {
            return false;
        }
        GetRevocationStatusRequest other = (GetRevocationStatusRequest)obj;
        if (other.getSignatureTimestamp() == null ^ this.getSignatureTimestamp() == null) {
            return false;
        }
        if (other.getSignatureTimestamp() != null && !other.getSignatureTimestamp().equals(this.getSignatureTimestamp())) {
            return false;
        }
        if (other.getPlatformId() == null ^ this.getPlatformId() == null) {
            return false;
        }
        if (other.getPlatformId() != null && !other.getPlatformId().equals(this.getPlatformId())) {
            return false;
        }
        if (other.getProfileVersionArn() == null ^ this.getProfileVersionArn() == null) {
            return false;
        }
        if (other.getProfileVersionArn() != null && !other.getProfileVersionArn().equals(this.getProfileVersionArn())) {
            return false;
        }
        if (other.getJobArn() == null ^ this.getJobArn() == null) {
            return false;
        }
        if (other.getJobArn() != null && !other.getJobArn().equals(this.getJobArn())) {
            return false;
        }
        if (other.getCertificateHashes() == null ^ this.getCertificateHashes() == null) {
            return false;
        }
        return other.getCertificateHashes() == null || other.getCertificateHashes().equals(this.getCertificateHashes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSignatureTimestamp() == null ? 0 : this.getSignatureTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformId() == null ? 0 : this.getPlatformId().hashCode());
        hashCode = 31 * hashCode + (this.getProfileVersionArn() == null ? 0 : this.getProfileVersionArn().hashCode());
        hashCode = 31 * hashCode + (this.getJobArn() == null ? 0 : this.getJobArn().hashCode());
        hashCode = 31 * hashCode + (this.getCertificateHashes() == null ? 0 : this.getCertificateHashes().hashCode());
        return hashCode;
    }

    public GetRevocationStatusRequest clone() {
        return (GetRevocationStatusRequest)super.clone();
    }
}

