/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.signer.model.SigningPlatform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSigningPlatformsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<SigningPlatform> platforms;
    private String nextToken;

    public List<SigningPlatform> getPlatforms() {
        return this.platforms;
    }

    public void setPlatforms(Collection<SigningPlatform> platforms) {
        if (platforms == null) {
            this.platforms = null;
            return;
        }
        this.platforms = new ArrayList<SigningPlatform>(platforms);
    }

    public ListSigningPlatformsResult withPlatforms(SigningPlatform ... platforms) {
        if (this.platforms == null) {
            this.setPlatforms(new ArrayList<SigningPlatform>(platforms.length));
        }
        for (SigningPlatform ele : platforms) {
            this.platforms.add(ele);
        }
        return this;
    }

    public ListSigningPlatformsResult withPlatforms(Collection<SigningPlatform> platforms) {
        this.setPlatforms(platforms);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSigningPlatformsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlatforms() != null) {
            sb.append("Platforms: ").append(this.getPlatforms()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSigningPlatformsResult)) {
            return false;
        }
        ListSigningPlatformsResult other = (ListSigningPlatformsResult)obj;
        if (other.getPlatforms() == null ^ this.getPlatforms() == null) {
            return false;
        }
        if (other.getPlatforms() != null && !other.getPlatforms().equals(this.getPlatforms())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlatforms() == null ? 0 : this.getPlatforms().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListSigningPlatformsResult clone() {
        try {
            return (ListSigningPlatformsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

