/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simspaceweaver;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.simspaceweaver.AWSSimSpaceWeaver;
import com.amazonaws.services.simspaceweaver.AWSSimSpaceWeaverClientBuilder;
import com.amazonaws.services.simspaceweaver.model.AWSSimSpaceWeaverException;
import com.amazonaws.services.simspaceweaver.model.DeleteAppRequest;
import com.amazonaws.services.simspaceweaver.model.DeleteAppResult;
import com.amazonaws.services.simspaceweaver.model.DeleteSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.DeleteSimulationResult;
import com.amazonaws.services.simspaceweaver.model.DescribeAppRequest;
import com.amazonaws.services.simspaceweaver.model.DescribeAppResult;
import com.amazonaws.services.simspaceweaver.model.DescribeSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.DescribeSimulationResult;
import com.amazonaws.services.simspaceweaver.model.ListAppsRequest;
import com.amazonaws.services.simspaceweaver.model.ListAppsResult;
import com.amazonaws.services.simspaceweaver.model.ListSimulationsRequest;
import com.amazonaws.services.simspaceweaver.model.ListSimulationsResult;
import com.amazonaws.services.simspaceweaver.model.ListTagsForResourceRequest;
import com.amazonaws.services.simspaceweaver.model.ListTagsForResourceResult;
import com.amazonaws.services.simspaceweaver.model.StartAppRequest;
import com.amazonaws.services.simspaceweaver.model.StartAppResult;
import com.amazonaws.services.simspaceweaver.model.StartClockRequest;
import com.amazonaws.services.simspaceweaver.model.StartClockResult;
import com.amazonaws.services.simspaceweaver.model.StartSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.StartSimulationResult;
import com.amazonaws.services.simspaceweaver.model.StopAppRequest;
import com.amazonaws.services.simspaceweaver.model.StopAppResult;
import com.amazonaws.services.simspaceweaver.model.StopClockRequest;
import com.amazonaws.services.simspaceweaver.model.StopClockResult;
import com.amazonaws.services.simspaceweaver.model.StopSimulationRequest;
import com.amazonaws.services.simspaceweaver.model.StopSimulationResult;
import com.amazonaws.services.simspaceweaver.model.TagResourceRequest;
import com.amazonaws.services.simspaceweaver.model.TagResourceResult;
import com.amazonaws.services.simspaceweaver.model.UntagResourceRequest;
import com.amazonaws.services.simspaceweaver.model.UntagResourceResult;
import com.amazonaws.services.simspaceweaver.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DeleteAppRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DeleteAppResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DeleteSimulationRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DeleteSimulationResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DescribeAppRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DescribeAppResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DescribeSimulationRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.DescribeSimulationResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ListAppsRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ListAppsResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ListSimulationsRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ListSimulationsResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StartAppRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StartAppResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StartClockRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StartClockResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StartSimulationRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StartSimulationResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StopAppRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StopAppResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StopClockRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StopClockResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StopSimulationRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.StopSimulationResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.TooManyTagsExceptionUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.simspaceweaver.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSSimSpaceWeaverClient
extends AmazonWebServiceClient
implements AWSSimSpaceWeaver {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSSimSpaceWeaver.class);
    private static final String DEFAULT_SIGNING_NAME = "simspaceweaver";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("application/json").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("TooManyTagsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)TooManyTagsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSSimSpaceWeaverException.class));

    public static AWSSimSpaceWeaverClientBuilder builder() {
        return AWSSimSpaceWeaverClientBuilder.standard();
    }

    AWSSimSpaceWeaverClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSSimSpaceWeaverClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("simspaceweaver.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simspaceweaver/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/simspaceweaver/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteAppResult deleteApp(DeleteAppRequest request) {
        request = (DeleteAppRequest)this.beforeClientExecution(request);
        return this.executeDeleteApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteAppResult executeDeleteApp(DeleteAppRequest deleteAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteAppRequestProtocolMarshaller(protocolFactory).marshall((DeleteAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteAppResult deleteAppResult = (DeleteAppResult)response.getAwsResponse();
            return deleteAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteSimulationResult deleteSimulation(DeleteSimulationRequest request) {
        request = (DeleteSimulationRequest)this.beforeClientExecution(request);
        return this.executeDeleteSimulation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteSimulationResult executeDeleteSimulation(DeleteSimulationRequest deleteSimulationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteSimulationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteSimulationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteSimulationRequestProtocolMarshaller(protocolFactory).marshall((DeleteSimulationRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteSimulationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteSimulation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteSimulationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteSimulationResult deleteSimulationResult = (DeleteSimulationResult)response.getAwsResponse();
            return deleteSimulationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeAppResult describeApp(DescribeAppRequest request) {
        request = (DescribeAppRequest)this.beforeClientExecution(request);
        return this.executeDescribeApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeAppResult executeDescribeApp(DescribeAppRequest describeAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeAppRequestProtocolMarshaller(protocolFactory).marshall((DescribeAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeAppResult describeAppResult = (DescribeAppResult)response.getAwsResponse();
            return describeAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeSimulationResult describeSimulation(DescribeSimulationRequest request) {
        request = (DescribeSimulationRequest)this.beforeClientExecution(request);
        return this.executeDescribeSimulation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeSimulationResult executeDescribeSimulation(DescribeSimulationRequest describeSimulationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeSimulationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeSimulationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeSimulationRequestProtocolMarshaller(protocolFactory).marshall((DescribeSimulationRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeSimulationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeSimulation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeSimulationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeSimulationResult describeSimulationResult = (DescribeSimulationResult)response.getAwsResponse();
            return describeSimulationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListAppsResult listApps(ListAppsRequest request) {
        request = (ListAppsRequest)this.beforeClientExecution(request);
        return this.executeListApps(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListAppsResult executeListApps(ListAppsRequest listAppsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAppsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListAppsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListAppsRequestProtocolMarshaller(protocolFactory).marshall((ListAppsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listAppsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListApps");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListAppsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListAppsResult listAppsResult = (ListAppsResult)response.getAwsResponse();
            return listAppsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListSimulationsResult listSimulations(ListSimulationsRequest request) {
        request = (ListSimulationsRequest)this.beforeClientExecution(request);
        return this.executeListSimulations(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListSimulationsResult executeListSimulations(ListSimulationsRequest listSimulationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listSimulationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListSimulationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListSimulationsRequestProtocolMarshaller(protocolFactory).marshall((ListSimulationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listSimulationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListSimulations");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListSimulationsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListSimulationsResult listSimulationsResult = (ListSimulationsResult)response.getAwsResponse();
            return listSimulationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartAppResult startApp(StartAppRequest request) {
        request = (StartAppRequest)this.beforeClientExecution(request);
        return this.executeStartApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartAppResult executeStartApp(StartAppRequest startAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartAppRequestProtocolMarshaller(protocolFactory).marshall((StartAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)startAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartAppResult startAppResult = (StartAppResult)response.getAwsResponse();
            return startAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartClockResult startClock(StartClockRequest request) {
        request = (StartClockRequest)this.beforeClientExecution(request);
        return this.executeStartClock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartClockResult executeStartClock(StartClockRequest startClockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startClockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartClockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartClockRequestProtocolMarshaller(protocolFactory).marshall((StartClockRequest)super.beforeMarshalling((AmazonWebServiceRequest)startClockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartClock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartClockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartClockResult startClockResult = (StartClockResult)response.getAwsResponse();
            return startClockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartSimulationResult startSimulation(StartSimulationRequest request) {
        request = (StartSimulationRequest)this.beforeClientExecution(request);
        return this.executeStartSimulation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartSimulationResult executeStartSimulation(StartSimulationRequest startSimulationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startSimulationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartSimulationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartSimulationRequestProtocolMarshaller(protocolFactory).marshall((StartSimulationRequest)super.beforeMarshalling((AmazonWebServiceRequest)startSimulationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartSimulation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartSimulationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartSimulationResult startSimulationResult = (StartSimulationResult)response.getAwsResponse();
            return startSimulationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopAppResult stopApp(StopAppRequest request) {
        request = (StopAppRequest)this.beforeClientExecution(request);
        return this.executeStopApp(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopAppResult executeStopApp(StopAppRequest stopAppRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopAppRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopAppRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopAppRequestProtocolMarshaller(protocolFactory).marshall((StopAppRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopAppRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopApp");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopAppResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopAppResult stopAppResult = (StopAppResult)response.getAwsResponse();
            return stopAppResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopClockResult stopClock(StopClockRequest request) {
        request = (StopClockRequest)this.beforeClientExecution(request);
        return this.executeStopClock(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopClockResult executeStopClock(StopClockRequest stopClockRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopClockRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopClockRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopClockRequestProtocolMarshaller(protocolFactory).marshall((StopClockRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopClockRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopClock");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopClockResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopClockResult stopClockResult = (StopClockResult)response.getAwsResponse();
            return stopClockResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopSimulationResult stopSimulation(StopSimulationRequest request) {
        request = (StopSimulationRequest)this.beforeClientExecution(request);
        return this.executeStopSimulation(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopSimulationResult executeStopSimulation(StopSimulationRequest stopSimulationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopSimulationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopSimulationRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopSimulationRequestProtocolMarshaller(protocolFactory).marshall((StopSimulationRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopSimulationRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopSimulation");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopSimulationResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopSimulationResult stopSimulationResult = (StopSimulationResult)response.getAwsResponse();
            return stopSimulationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SimSpaceWeaver");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

