/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simspaceweaver.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.simspaceweaver.model.transform.S3DestinationMarshaller;
import java.io.Serializable;

public class S3Destination
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucketName;
    private String objectKeyPrefix;

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public S3Destination withBucketName(String bucketName) {
        this.setBucketName(bucketName);
        return this;
    }

    public void setObjectKeyPrefix(String objectKeyPrefix) {
        this.objectKeyPrefix = objectKeyPrefix;
    }

    public String getObjectKeyPrefix() {
        return this.objectKeyPrefix;
    }

    public S3Destination withObjectKeyPrefix(String objectKeyPrefix) {
        this.setObjectKeyPrefix(objectKeyPrefix);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucketName() != null) {
            sb.append("BucketName: ").append(this.getBucketName()).append(",");
        }
        if (this.getObjectKeyPrefix() != null) {
            sb.append("ObjectKeyPrefix: ").append(this.getObjectKeyPrefix());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Destination)) {
            return false;
        }
        S3Destination other = (S3Destination)obj;
        if (other.getBucketName() == null ^ this.getBucketName() == null) {
            return false;
        }
        if (other.getBucketName() != null && !other.getBucketName().equals(this.getBucketName())) {
            return false;
        }
        if (other.getObjectKeyPrefix() == null ^ this.getObjectKeyPrefix() == null) {
            return false;
        }
        return other.getObjectKeyPrefix() == null || other.getObjectKeyPrefix().equals(this.getObjectKeyPrefix());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucketName() == null ? 0 : this.getBucketName().hashCode());
        hashCode = 31 * hashCode + (this.getObjectKeyPrefix() == null ? 0 : this.getObjectKeyPrefix().hashCode());
        return hashCode;
    }

    public S3Destination clone() {
        try {
            return (S3Destination)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DestinationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

