/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.UpdateJobRequest;
import com.amazonaws.services.snowball.model.transform.JobResourceJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.NotificationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class UpdateJobRequestMarshaller
implements Marshaller<Request<UpdateJobRequest>, UpdateJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UpdateJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateJobRequest> marshall(UpdateJobRequest updateJobRequest) {
        if (updateJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateJobRequest, "AmazonSnowball");
        request.addHeader("X-Amz-Target", "AWSIESnowballJobManagementService.UpdateJob");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateJobRequest.getJobId() != null) {
                jsonGenerator.writeFieldName("JobId").writeValue(updateJobRequest.getJobId());
            }
            if (updateJobRequest.getRoleARN() != null) {
                jsonGenerator.writeFieldName("RoleARN").writeValue(updateJobRequest.getRoleARN());
            }
            if (updateJobRequest.getNotification() != null) {
                jsonGenerator.writeFieldName("Notification");
                NotificationJsonMarshaller.getInstance().marshall(updateJobRequest.getNotification(), jsonGenerator);
            }
            if (updateJobRequest.getResources() != null) {
                jsonGenerator.writeFieldName("Resources");
                JobResourceJsonMarshaller.getInstance().marshall(updateJobRequest.getResources(), jsonGenerator);
            }
            if (updateJobRequest.getAddressId() != null) {
                jsonGenerator.writeFieldName("AddressId").writeValue(updateJobRequest.getAddressId());
            }
            if (updateJobRequest.getShippingOption() != null) {
                jsonGenerator.writeFieldName("ShippingOption").writeValue(updateJobRequest.getShippingOption());
            }
            if (updateJobRequest.getDescription() != null) {
                jsonGenerator.writeFieldName("Description").writeValue(updateJobRequest.getDescription());
            }
            if (updateJobRequest.getSnowballCapacityPreference() != null) {
                jsonGenerator.writeFieldName("SnowballCapacityPreference").writeValue(updateJobRequest.getSnowballCapacityPreference());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

