/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.snowball.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/CreateAddress" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateAddressRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The address that you want the Snowball shipped to.
     * </p>
     */
    private Address address;

    /**
     * <p>
     * The address that you want the Snowball shipped to.
     * </p>
     * 
     * @param address
     *        The address that you want the Snowball shipped to.
     */

    public void setAddress(Address address) {
        this.address = address;
    }

    /**
     * <p>
     * The address that you want the Snowball shipped to.
     * </p>
     * 
     * @return The address that you want the Snowball shipped to.
     */

    public Address getAddress() {
        return this.address;
    }

    /**
     * <p>
     * The address that you want the Snowball shipped to.
     * </p>
     * 
     * @param address
     *        The address that you want the Snowball shipped to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAddressRequest withAddress(Address address) {
        setAddress(address);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAddress() != null)
            sb.append("Address: ").append(getAddress());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateAddressRequest == false)
            return false;
        CreateAddressRequest other = (CreateAddressRequest) obj;
        if (other.getAddress() == null ^ this.getAddress() == null)
            return false;
        if (other.getAddress() != null && other.getAddress().equals(this.getAddress()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAddress() == null) ? 0 : getAddress().hashCode());
        return hashCode;
    }

    @Override
    public CreateAddressRequest clone() {
        return (CreateAddressRequest) super.clone();
    }

}
