/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssmcontacts;

import javax.annotation.Generated;

import com.amazonaws.services.ssmcontacts.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSSSMContacts}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSSMContacts implements AWSSSMContacts {

    protected AbstractAWSSSMContacts() {
    }

    @Override
    public AcceptPageResult acceptPage(AcceptPageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ActivateContactChannelResult activateContactChannel(ActivateContactChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateContactResult createContact(CreateContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateContactChannelResult createContactChannel(CreateContactChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRotationResult createRotation(CreateRotationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRotationOverrideResult createRotationOverride(CreateRotationOverrideRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeactivateContactChannelResult deactivateContactChannel(DeactivateContactChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteContactResult deleteContact(DeleteContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteContactChannelResult deleteContactChannel(DeleteContactChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRotationResult deleteRotation(DeleteRotationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRotationOverrideResult deleteRotationOverride(DeleteRotationOverrideRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeEngagementResult describeEngagement(DescribeEngagementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePageResult describePage(DescribePageRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetContactResult getContact(GetContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetContactChannelResult getContactChannel(GetContactChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetContactPolicyResult getContactPolicy(GetContactPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRotationResult getRotation(GetRotationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRotationOverrideResult getRotationOverride(GetRotationOverrideRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListContactChannelsResult listContactChannels(ListContactChannelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListContactsResult listContacts(ListContactsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListEngagementsResult listEngagements(ListEngagementsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPageReceiptsResult listPageReceipts(ListPageReceiptsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPageResolutionsResult listPageResolutions(ListPageResolutionsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPagesByContactResult listPagesByContact(ListPagesByContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPagesByEngagementResult listPagesByEngagement(ListPagesByEngagementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPreviewRotationShiftsResult listPreviewRotationShifts(ListPreviewRotationShiftsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRotationOverridesResult listRotationOverrides(ListRotationOverridesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRotationShiftsResult listRotationShifts(ListRotationShiftsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRotationsResult listRotations(ListRotationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutContactPolicyResult putContactPolicy(PutContactPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public SendActivationCodeResult sendActivationCode(SendActivationCodeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartEngagementResult startEngagement(StartEngagementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopEngagementResult stopEngagement(StopEngagementRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateContactResult updateContact(UpdateContactRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateContactChannelResult updateContactChannel(UpdateContactChannelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRotationResult updateRotation(UpdateRotationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
