/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ssoadmin;

import javax.annotation.Generated;

import com.amazonaws.services.ssoadmin.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSSSOAdmin}. Convenient method forms pass through to the corresponding overload
 * that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSSSOAdmin implements AWSSSOAdmin {

    protected AbstractAWSSSOAdmin() {
    }

    @Override
    public AttachCustomerManagedPolicyReferenceToPermissionSetResult attachCustomerManagedPolicyReferenceToPermissionSet(
            AttachCustomerManagedPolicyReferenceToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public AttachManagedPolicyToPermissionSetResult attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateAccountAssignmentResult createAccountAssignment(CreateAccountAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateApplicationAssignmentResult createApplicationAssignment(CreateApplicationAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInstanceResult createInstance(CreateInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateInstanceAccessControlAttributeConfigurationResult createInstanceAccessControlAttributeConfiguration(
            CreateInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreatePermissionSetResult createPermissionSet(CreatePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrustedTokenIssuerResult createTrustedTokenIssuer(CreateTrustedTokenIssuerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAccountAssignmentResult deleteAccountAssignment(DeleteAccountAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationResult deleteApplication(DeleteApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationAccessScopeResult deleteApplicationAccessScope(DeleteApplicationAccessScopeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationAssignmentResult deleteApplicationAssignment(DeleteApplicationAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationAuthenticationMethodResult deleteApplicationAuthenticationMethod(DeleteApplicationAuthenticationMethodRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteApplicationGrantResult deleteApplicationGrant(DeleteApplicationGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInlinePolicyFromPermissionSetResult deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInstanceResult deleteInstance(DeleteInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInstanceAccessControlAttributeConfigurationResult deleteInstanceAccessControlAttributeConfiguration(
            DeleteInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePermissionSetResult deletePermissionSet(DeletePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePermissionsBoundaryFromPermissionSetResult deletePermissionsBoundaryFromPermissionSet(DeletePermissionsBoundaryFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrustedTokenIssuerResult deleteTrustedTokenIssuer(DeleteTrustedTokenIssuerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountAssignmentCreationStatusResult describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeAccountAssignmentDeletionStatusResult describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicationResult describeApplication(DescribeApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicationAssignmentResult describeApplicationAssignment(DescribeApplicationAssignmentRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeApplicationProviderResult describeApplicationProvider(DescribeApplicationProviderRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstanceResult describeInstance(DescribeInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeInstanceAccessControlAttributeConfigurationResult describeInstanceAccessControlAttributeConfiguration(
            DescribeInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePermissionSetResult describePermissionSet(DescribePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribePermissionSetProvisioningStatusResult describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeTrustedTokenIssuerResult describeTrustedTokenIssuer(DescribeTrustedTokenIssuerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachCustomerManagedPolicyReferenceFromPermissionSetResult detachCustomerManagedPolicyReferenceFromPermissionSet(
            DetachCustomerManagedPolicyReferenceFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DetachManagedPolicyFromPermissionSetResult detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationAccessScopeResult getApplicationAccessScope(GetApplicationAccessScopeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationAssignmentConfigurationResult getApplicationAssignmentConfiguration(GetApplicationAssignmentConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationAuthenticationMethodResult getApplicationAuthenticationMethod(GetApplicationAuthenticationMethodRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetApplicationGrantResult getApplicationGrant(GetApplicationGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInlinePolicyForPermissionSetResult getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPermissionsBoundaryForPermissionSetResult getPermissionsBoundaryForPermissionSet(GetPermissionsBoundaryForPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssignmentCreationStatusResult listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssignmentDeletionStatusResult listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssignmentsResult listAccountAssignments(ListAccountAssignmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountAssignmentsForPrincipalResult listAccountAssignmentsForPrincipal(ListAccountAssignmentsForPrincipalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAccountsForProvisionedPermissionSetResult listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationAccessScopesResult listApplicationAccessScopes(ListApplicationAccessScopesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationAssignmentsResult listApplicationAssignments(ListApplicationAssignmentsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationAssignmentsForPrincipalResult listApplicationAssignmentsForPrincipal(ListApplicationAssignmentsForPrincipalRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationAuthenticationMethodsResult listApplicationAuthenticationMethods(ListApplicationAuthenticationMethodsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationGrantsResult listApplicationGrants(ListApplicationGrantsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationProvidersResult listApplicationProviders(ListApplicationProvidersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListApplicationsResult listApplications(ListApplicationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCustomerManagedPolicyReferencesInPermissionSetResult listCustomerManagedPolicyReferencesInPermissionSet(
            ListCustomerManagedPolicyReferencesInPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListInstancesResult listInstances(ListInstancesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListManagedPoliciesInPermissionSetResult listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionSetProvisioningStatusResult listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionSetsResult listPermissionSets(ListPermissionSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListPermissionSetsProvisionedToAccountResult listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrustedTokenIssuersResult listTrustedTokenIssuers(ListTrustedTokenIssuersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ProvisionPermissionSetResult provisionPermissionSet(ProvisionPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutApplicationAccessScopeResult putApplicationAccessScope(PutApplicationAccessScopeRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutApplicationAssignmentConfigurationResult putApplicationAssignmentConfiguration(PutApplicationAssignmentConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutApplicationAuthenticationMethodResult putApplicationAuthenticationMethod(PutApplicationAuthenticationMethodRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutApplicationGrantResult putApplicationGrant(PutApplicationGrantRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutInlinePolicyToPermissionSetResult putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutPermissionsBoundaryToPermissionSetResult putPermissionsBoundaryToPermissionSet(PutPermissionsBoundaryToPermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInstanceResult updateInstance(UpdateInstanceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateInstanceAccessControlAttributeConfigurationResult updateInstanceAccessControlAttributeConfiguration(
            UpdateInstanceAccessControlAttributeConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdatePermissionSetResult updatePermissionSet(UpdatePermissionSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateTrustedTokenIssuerResult updateTrustedTokenIssuer(UpdateTrustedTokenIssuerRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
