/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test.util;

import java.lang.reflect.Field;
import java.util.Map;

public class EnvironmentVariableHelper {
    private final Map<String, String> originalEnvironmentVariables;
    private final Map<String, String> modifiableMap;
    private volatile boolean mutated = false;

    public EnvironmentVariableHelper() {
        try {
            this.originalEnvironmentVariables = System.getenv();
            Field f = this.originalEnvironmentVariables.getClass().getDeclaredField("m");
            f.setAccessible(true);
            this.modifiableMap = (Map)f.get(this.originalEnvironmentVariables);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void set(String key, String value) {
        this.mutated = true;
        this.modifiableMap.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.mutated) {
            EnvironmentVariableHelper environmentVariableHelper = this;
            synchronized (environmentVariableHelper) {
                if (this.mutated) {
                    this.modifiableMap.clear();
                    this.modifiableMap.putAll(this.originalEnvironmentVariables);
                    this.mutated = false;
                }
            }
        }
    }

    protected void finalize() {
        this.reset();
    }
}

