/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.test.util;

import java.util.Iterator;

public class IndexValues
implements Iterable<int[]> {
    private final int[] lengths;

    public IndexValues(int ... lengths) {
        if (lengths == null || lengths.length == 0) {
            throw new IllegalArgumentException();
        }
        for (int len : lengths) {
            if (len >= 1) continue;
            throw new IllegalArgumentException();
        }
        this.lengths = (int[])lengths.clone();
    }

    @Override
    public Iterator<int[]> iterator() {
        return new Iter(this.lengths);
    }

    private static class Iter
    implements Iterator<int[]> {
        private final int[] lengths;
        private int[] curr;

        private Iter(int[] lengths) {
            this.lengths = lengths;
            this.curr = new int[lengths.length];
        }

        @Override
        public boolean hasNext() {
            return this.curr != null;
        }

        @Override
        public int[] next() {
            if (this.curr == null) {
                return null;
            }
            int last = this.lengths.length - 1;
            if (this.curr[last] < this.lengths[last] - 1) {
                int[] ret = (int[])this.curr.clone();
                int n = last;
                this.curr[n] = this.curr[n] + 1;
                return ret;
            }
            if (this.curr[last] == this.lengths[last] - 1) {
                for (int j = last - 1; j >= 0; --j) {
                    if (this.curr[j] >= this.lengths[j] - 1) continue;
                    int[] ret = (int[])this.curr.clone();
                    int n = j;
                    this.curr[n] = this.curr[n] + 1;
                    for (int k = j + 1; k < this.lengths.length; ++k) {
                        this.curr[k] = 0;
                    }
                    return ret;
                }
                int[] ret = this.curr;
                this.curr = null;
                return ret;
            }
            throw new IllegalStateException("Bug ?");
        }

        @Override
        public void remove() {
        }
    }
}

