/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.textract.AmazonTextractAsync;
import com.amazonaws.services.textract.AmazonTextractAsyncClientBuilder;
import com.amazonaws.services.textract.AmazonTextractClient;
import com.amazonaws.services.textract.model.AnalyzeDocumentRequest;
import com.amazonaws.services.textract.model.AnalyzeDocumentResult;
import com.amazonaws.services.textract.model.DetectDocumentTextRequest;
import com.amazonaws.services.textract.model.DetectDocumentTextResult;
import com.amazonaws.services.textract.model.GetDocumentAnalysisRequest;
import com.amazonaws.services.textract.model.GetDocumentAnalysisResult;
import com.amazonaws.services.textract.model.GetDocumentTextDetectionRequest;
import com.amazonaws.services.textract.model.GetDocumentTextDetectionResult;
import com.amazonaws.services.textract.model.StartDocumentAnalysisRequest;
import com.amazonaws.services.textract.model.StartDocumentAnalysisResult;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionRequest;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTextractAsyncClient
extends AmazonTextractClient
implements AmazonTextractAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTextractAsyncClientBuilder asyncBuilder() {
        return AmazonTextractAsyncClientBuilder.standard();
    }

    AmazonTextractAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonTextractAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AnalyzeDocumentResult> analyzeDocumentAsync(AnalyzeDocumentRequest request) {
        return this.analyzeDocumentAsync(request, null);
    }

    @Override
    public Future<AnalyzeDocumentResult> analyzeDocumentAsync(AnalyzeDocumentRequest request, final AsyncHandler<AnalyzeDocumentRequest, AnalyzeDocumentResult> asyncHandler) {
        final AnalyzeDocumentRequest finalRequest = (AnalyzeDocumentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AnalyzeDocumentResult>(){

            @Override
            public AnalyzeDocumentResult call() throws Exception {
                AnalyzeDocumentResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeAnalyzeDocument(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectDocumentTextResult> detectDocumentTextAsync(DetectDocumentTextRequest request) {
        return this.detectDocumentTextAsync(request, null);
    }

    @Override
    public Future<DetectDocumentTextResult> detectDocumentTextAsync(DetectDocumentTextRequest request, final AsyncHandler<DetectDocumentTextRequest, DetectDocumentTextResult> asyncHandler) {
        final DetectDocumentTextRequest finalRequest = (DetectDocumentTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectDocumentTextResult>(){

            @Override
            public DetectDocumentTextResult call() throws Exception {
                DetectDocumentTextResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeDetectDocumentText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentAnalysisResult> getDocumentAnalysisAsync(GetDocumentAnalysisRequest request) {
        return this.getDocumentAnalysisAsync(request, null);
    }

    @Override
    public Future<GetDocumentAnalysisResult> getDocumentAnalysisAsync(GetDocumentAnalysisRequest request, final AsyncHandler<GetDocumentAnalysisRequest, GetDocumentAnalysisResult> asyncHandler) {
        final GetDocumentAnalysisRequest finalRequest = (GetDocumentAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDocumentAnalysisResult>(){

            @Override
            public GetDocumentAnalysisResult call() throws Exception {
                GetDocumentAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetDocumentAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentTextDetectionResult> getDocumentTextDetectionAsync(GetDocumentTextDetectionRequest request) {
        return this.getDocumentTextDetectionAsync(request, null);
    }

    @Override
    public Future<GetDocumentTextDetectionResult> getDocumentTextDetectionAsync(GetDocumentTextDetectionRequest request, final AsyncHandler<GetDocumentTextDetectionRequest, GetDocumentTextDetectionResult> asyncHandler) {
        final GetDocumentTextDetectionRequest finalRequest = (GetDocumentTextDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDocumentTextDetectionResult>(){

            @Override
            public GetDocumentTextDetectionResult call() throws Exception {
                GetDocumentTextDetectionResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetDocumentTextDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDocumentAnalysisResult> startDocumentAnalysisAsync(StartDocumentAnalysisRequest request) {
        return this.startDocumentAnalysisAsync(request, null);
    }

    @Override
    public Future<StartDocumentAnalysisResult> startDocumentAnalysisAsync(StartDocumentAnalysisRequest request, final AsyncHandler<StartDocumentAnalysisRequest, StartDocumentAnalysisResult> asyncHandler) {
        final StartDocumentAnalysisRequest finalRequest = (StartDocumentAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDocumentAnalysisResult>(){

            @Override
            public StartDocumentAnalysisResult call() throws Exception {
                StartDocumentAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeStartDocumentAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDocumentTextDetectionResult> startDocumentTextDetectionAsync(StartDocumentTextDetectionRequest request) {
        return this.startDocumentTextDetectionAsync(request, null);
    }

    @Override
    public Future<StartDocumentTextDetectionResult> startDocumentTextDetectionAsync(StartDocumentTextDetectionRequest request, final AsyncHandler<StartDocumentTextDetectionRequest, StartDocumentTextDetectionResult> asyncHandler) {
        final StartDocumentTextDetectionRequest finalRequest = (StartDocumentTextDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDocumentTextDetectionResult>(){

            @Override
            public StartDocumentTextDetectionResult call() throws Exception {
                StartDocumentTextDetectionResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeStartDocumentTextDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

