/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.transform.WarningMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Warning
implements Serializable,
Cloneable,
StructuredPojo {
    private String errorCode;
    private List<Integer> pages;

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Warning withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public List<Integer> getPages() {
        return this.pages;
    }

    public void setPages(Collection<Integer> pages) {
        if (pages == null) {
            this.pages = null;
            return;
        }
        this.pages = new ArrayList<Integer>(pages);
    }

    public Warning withPages(Integer ... pages) {
        if (this.pages == null) {
            this.setPages(new ArrayList<Integer>(pages.length));
        }
        for (Integer ele : pages) {
            this.pages.add(ele);
        }
        return this;
    }

    public Warning withPages(Collection<Integer> pages) {
        this.setPages(pages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getPages() != null) {
            sb.append("Pages: ").append(this.getPages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Warning)) {
            return false;
        }
        Warning other = (Warning)obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getPages() == null ^ this.getPages() == null) {
            return false;
        }
        return other.getPages() == null || other.getPages().equals(this.getPages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getPages() == null ? 0 : this.getPages().hashCode());
        return hashCode;
    }

    public Warning clone() {
        try {
            return (Warning)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WarningMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

