/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.textract.model;

import javax.annotation.Generated;

/**
 * <p>
 * Amazon Textract is unable to access the S3 object that's specified in the request. for more information, <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html">Configure Access to Amazon S3</a> For
 * troubleshooting information, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html">Troubleshooting Amazon S3</a>
 * </p>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InvalidS3ObjectException extends com.amazonaws.services.textract.model.AmazonTextractException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new InvalidS3ObjectException with the specified error message.
     *
     * @param message
     *        Describes the error encountered.
     */
    public InvalidS3ObjectException(String message) {
        super(message);
    }

}
