/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.textract.model.DocumentMetadata;
import com.amazonaws.services.textract.model.JobStatus;
import com.amazonaws.services.textract.model.LendingResult;
import com.amazonaws.services.textract.model.Warning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetLendingAnalysisResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private DocumentMetadata documentMetadata;
    private String jobStatus;
    private String nextToken;
    private List<LendingResult> results;
    private List<Warning> warnings;
    private String statusMessage;
    private String analyzeLendingModelVersion;

    public void setDocumentMetadata(DocumentMetadata documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    public DocumentMetadata getDocumentMetadata() {
        return this.documentMetadata;
    }

    public GetLendingAnalysisResult withDocumentMetadata(DocumentMetadata documentMetadata) {
        this.setDocumentMetadata(documentMetadata);
        return this;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public GetLendingAnalysisResult withJobStatus(String jobStatus) {
        this.setJobStatus(jobStatus);
        return this;
    }

    public GetLendingAnalysisResult withJobStatus(JobStatus jobStatus) {
        this.jobStatus = jobStatus.toString();
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public GetLendingAnalysisResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<LendingResult> getResults() {
        return this.results;
    }

    public void setResults(Collection<LendingResult> results) {
        if (results == null) {
            this.results = null;
            return;
        }
        this.results = new ArrayList<LendingResult>(results);
    }

    public GetLendingAnalysisResult withResults(LendingResult ... results) {
        if (this.results == null) {
            this.setResults(new ArrayList<LendingResult>(results.length));
        }
        for (LendingResult ele : results) {
            this.results.add(ele);
        }
        return this;
    }

    public GetLendingAnalysisResult withResults(Collection<LendingResult> results) {
        this.setResults(results);
        return this;
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Collection<Warning> warnings) {
        if (warnings == null) {
            this.warnings = null;
            return;
        }
        this.warnings = new ArrayList<Warning>(warnings);
    }

    public GetLendingAnalysisResult withWarnings(Warning ... warnings) {
        if (this.warnings == null) {
            this.setWarnings(new ArrayList<Warning>(warnings.length));
        }
        for (Warning ele : warnings) {
            this.warnings.add(ele);
        }
        return this;
    }

    public GetLendingAnalysisResult withWarnings(Collection<Warning> warnings) {
        this.setWarnings(warnings);
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public GetLendingAnalysisResult withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setAnalyzeLendingModelVersion(String analyzeLendingModelVersion) {
        this.analyzeLendingModelVersion = analyzeLendingModelVersion;
    }

    public String getAnalyzeLendingModelVersion() {
        return this.analyzeLendingModelVersion;
    }

    public GetLendingAnalysisResult withAnalyzeLendingModelVersion(String analyzeLendingModelVersion) {
        this.setAnalyzeLendingModelVersion(analyzeLendingModelVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentMetadata() != null) {
            sb.append("DocumentMetadata: ").append(this.getDocumentMetadata()).append(",");
        }
        if (this.getJobStatus() != null) {
            sb.append("JobStatus: ").append(this.getJobStatus()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getResults() != null) {
            sb.append("Results: ").append(this.getResults()).append(",");
        }
        if (this.getWarnings() != null) {
            sb.append("Warnings: ").append(this.getWarnings()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getAnalyzeLendingModelVersion() != null) {
            sb.append("AnalyzeLendingModelVersion: ").append(this.getAnalyzeLendingModelVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLendingAnalysisResult)) {
            return false;
        }
        GetLendingAnalysisResult other = (GetLendingAnalysisResult)obj;
        if (other.getDocumentMetadata() == null ^ this.getDocumentMetadata() == null) {
            return false;
        }
        if (other.getDocumentMetadata() != null && !other.getDocumentMetadata().equals(this.getDocumentMetadata())) {
            return false;
        }
        if (other.getJobStatus() == null ^ this.getJobStatus() == null) {
            return false;
        }
        if (other.getJobStatus() != null && !other.getJobStatus().equals(this.getJobStatus())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getResults() == null ^ this.getResults() == null) {
            return false;
        }
        if (other.getResults() != null && !other.getResults().equals(this.getResults())) {
            return false;
        }
        if (other.getWarnings() == null ^ this.getWarnings() == null) {
            return false;
        }
        if (other.getWarnings() != null && !other.getWarnings().equals(this.getWarnings())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getAnalyzeLendingModelVersion() == null ^ this.getAnalyzeLendingModelVersion() == null) {
            return false;
        }
        return other.getAnalyzeLendingModelVersion() == null || other.getAnalyzeLendingModelVersion().equals(this.getAnalyzeLendingModelVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentMetadata() == null ? 0 : this.getDocumentMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getJobStatus() == null ? 0 : this.getJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getResults() == null ? 0 : this.getResults().hashCode());
        hashCode = 31 * hashCode + (this.getWarnings() == null ? 0 : this.getWarnings().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getAnalyzeLendingModelVersion() == null ? 0 : this.getAnalyzeLendingModelVersion().hashCode());
        return hashCode;
    }

    public GetLendingAnalysisResult clone() {
        try {
            return (GetLendingAnalysisResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

