/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.textract.model.Document;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalyzeIDRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<Document> documentPages;

    public List<Document> getDocumentPages() {
        return this.documentPages;
    }

    public void setDocumentPages(Collection<Document> documentPages) {
        if (documentPages == null) {
            this.documentPages = null;
            return;
        }
        this.documentPages = new ArrayList<Document>(documentPages);
    }

    public AnalyzeIDRequest withDocumentPages(Document ... documentPages) {
        if (this.documentPages == null) {
            this.setDocumentPages(new ArrayList<Document>(documentPages.length));
        }
        for (Document ele : documentPages) {
            this.documentPages.add(ele);
        }
        return this;
    }

    public AnalyzeIDRequest withDocumentPages(Collection<Document> documentPages) {
        this.setDocumentPages(documentPages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDocumentPages() != null) {
            sb.append("DocumentPages: ").append(this.getDocumentPages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeIDRequest)) {
            return false;
        }
        AnalyzeIDRequest other = (AnalyzeIDRequest)obj;
        if (other.getDocumentPages() == null ^ this.getDocumentPages() == null) {
            return false;
        }
        return other.getDocumentPages() == null || other.getDocumentPages().equals(this.getDocumentPages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDocumentPages() == null ? 0 : this.getDocumentPages().hashCode());
        return hashCode;
    }

    public AnalyzeIDRequest clone() {
        return (AnalyzeIDRequest)super.clone();
    }
}

