/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.textract.AmazonTextractAsync;
import com.amazonaws.services.textract.AmazonTextractAsyncClientBuilder;
import com.amazonaws.services.textract.AmazonTextractClient;
import com.amazonaws.services.textract.model.AnalyzeDocumentRequest;
import com.amazonaws.services.textract.model.AnalyzeDocumentResult;
import com.amazonaws.services.textract.model.AnalyzeExpenseRequest;
import com.amazonaws.services.textract.model.AnalyzeExpenseResult;
import com.amazonaws.services.textract.model.AnalyzeIDRequest;
import com.amazonaws.services.textract.model.AnalyzeIDResult;
import com.amazonaws.services.textract.model.CreateAdapterRequest;
import com.amazonaws.services.textract.model.CreateAdapterResult;
import com.amazonaws.services.textract.model.CreateAdapterVersionRequest;
import com.amazonaws.services.textract.model.CreateAdapterVersionResult;
import com.amazonaws.services.textract.model.DeleteAdapterRequest;
import com.amazonaws.services.textract.model.DeleteAdapterResult;
import com.amazonaws.services.textract.model.DeleteAdapterVersionRequest;
import com.amazonaws.services.textract.model.DeleteAdapterVersionResult;
import com.amazonaws.services.textract.model.DetectDocumentTextRequest;
import com.amazonaws.services.textract.model.DetectDocumentTextResult;
import com.amazonaws.services.textract.model.GetAdapterRequest;
import com.amazonaws.services.textract.model.GetAdapterResult;
import com.amazonaws.services.textract.model.GetAdapterVersionRequest;
import com.amazonaws.services.textract.model.GetAdapterVersionResult;
import com.amazonaws.services.textract.model.GetDocumentAnalysisRequest;
import com.amazonaws.services.textract.model.GetDocumentAnalysisResult;
import com.amazonaws.services.textract.model.GetDocumentTextDetectionRequest;
import com.amazonaws.services.textract.model.GetDocumentTextDetectionResult;
import com.amazonaws.services.textract.model.GetExpenseAnalysisRequest;
import com.amazonaws.services.textract.model.GetExpenseAnalysisResult;
import com.amazonaws.services.textract.model.GetLendingAnalysisRequest;
import com.amazonaws.services.textract.model.GetLendingAnalysisResult;
import com.amazonaws.services.textract.model.GetLendingAnalysisSummaryRequest;
import com.amazonaws.services.textract.model.GetLendingAnalysisSummaryResult;
import com.amazonaws.services.textract.model.ListAdapterVersionsRequest;
import com.amazonaws.services.textract.model.ListAdapterVersionsResult;
import com.amazonaws.services.textract.model.ListAdaptersRequest;
import com.amazonaws.services.textract.model.ListAdaptersResult;
import com.amazonaws.services.textract.model.ListTagsForResourceRequest;
import com.amazonaws.services.textract.model.ListTagsForResourceResult;
import com.amazonaws.services.textract.model.StartDocumentAnalysisRequest;
import com.amazonaws.services.textract.model.StartDocumentAnalysisResult;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionRequest;
import com.amazonaws.services.textract.model.StartDocumentTextDetectionResult;
import com.amazonaws.services.textract.model.StartExpenseAnalysisRequest;
import com.amazonaws.services.textract.model.StartExpenseAnalysisResult;
import com.amazonaws.services.textract.model.StartLendingAnalysisRequest;
import com.amazonaws.services.textract.model.StartLendingAnalysisResult;
import com.amazonaws.services.textract.model.TagResourceRequest;
import com.amazonaws.services.textract.model.TagResourceResult;
import com.amazonaws.services.textract.model.UntagResourceRequest;
import com.amazonaws.services.textract.model.UntagResourceResult;
import com.amazonaws.services.textract.model.UpdateAdapterRequest;
import com.amazonaws.services.textract.model.UpdateAdapterResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonTextractAsyncClient
extends AmazonTextractClient
implements AmazonTextractAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonTextractAsyncClientBuilder asyncBuilder() {
        return AmazonTextractAsyncClientBuilder.standard();
    }

    AmazonTextractAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonTextractAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AnalyzeDocumentResult> analyzeDocumentAsync(AnalyzeDocumentRequest request) {
        return this.analyzeDocumentAsync(request, null);
    }

    @Override
    public Future<AnalyzeDocumentResult> analyzeDocumentAsync(AnalyzeDocumentRequest request, final AsyncHandler<AnalyzeDocumentRequest, AnalyzeDocumentResult> asyncHandler) {
        final AnalyzeDocumentRequest finalRequest = (AnalyzeDocumentRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AnalyzeDocumentResult>(){

            @Override
            public AnalyzeDocumentResult call() throws Exception {
                AnalyzeDocumentResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeAnalyzeDocument(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AnalyzeExpenseResult> analyzeExpenseAsync(AnalyzeExpenseRequest request) {
        return this.analyzeExpenseAsync(request, null);
    }

    @Override
    public Future<AnalyzeExpenseResult> analyzeExpenseAsync(AnalyzeExpenseRequest request, final AsyncHandler<AnalyzeExpenseRequest, AnalyzeExpenseResult> asyncHandler) {
        final AnalyzeExpenseRequest finalRequest = (AnalyzeExpenseRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AnalyzeExpenseResult>(){

            @Override
            public AnalyzeExpenseResult call() throws Exception {
                AnalyzeExpenseResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeAnalyzeExpense(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AnalyzeIDResult> analyzeIDAsync(AnalyzeIDRequest request) {
        return this.analyzeIDAsync(request, null);
    }

    @Override
    public Future<AnalyzeIDResult> analyzeIDAsync(AnalyzeIDRequest request, final AsyncHandler<AnalyzeIDRequest, AnalyzeIDResult> asyncHandler) {
        final AnalyzeIDRequest finalRequest = (AnalyzeIDRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AnalyzeIDResult>(){

            @Override
            public AnalyzeIDResult call() throws Exception {
                AnalyzeIDResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeAnalyzeID(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAdapterResult> createAdapterAsync(CreateAdapterRequest request) {
        return this.createAdapterAsync(request, null);
    }

    @Override
    public Future<CreateAdapterResult> createAdapterAsync(CreateAdapterRequest request, final AsyncHandler<CreateAdapterRequest, CreateAdapterResult> asyncHandler) {
        final CreateAdapterRequest finalRequest = (CreateAdapterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAdapterResult>(){

            @Override
            public CreateAdapterResult call() throws Exception {
                CreateAdapterResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeCreateAdapter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAdapterVersionResult> createAdapterVersionAsync(CreateAdapterVersionRequest request) {
        return this.createAdapterVersionAsync(request, null);
    }

    @Override
    public Future<CreateAdapterVersionResult> createAdapterVersionAsync(CreateAdapterVersionRequest request, final AsyncHandler<CreateAdapterVersionRequest, CreateAdapterVersionResult> asyncHandler) {
        final CreateAdapterVersionRequest finalRequest = (CreateAdapterVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAdapterVersionResult>(){

            @Override
            public CreateAdapterVersionResult call() throws Exception {
                CreateAdapterVersionResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeCreateAdapterVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAdapterResult> deleteAdapterAsync(DeleteAdapterRequest request) {
        return this.deleteAdapterAsync(request, null);
    }

    @Override
    public Future<DeleteAdapterResult> deleteAdapterAsync(DeleteAdapterRequest request, final AsyncHandler<DeleteAdapterRequest, DeleteAdapterResult> asyncHandler) {
        final DeleteAdapterRequest finalRequest = (DeleteAdapterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAdapterResult>(){

            @Override
            public DeleteAdapterResult call() throws Exception {
                DeleteAdapterResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeDeleteAdapter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteAdapterVersionResult> deleteAdapterVersionAsync(DeleteAdapterVersionRequest request) {
        return this.deleteAdapterVersionAsync(request, null);
    }

    @Override
    public Future<DeleteAdapterVersionResult> deleteAdapterVersionAsync(DeleteAdapterVersionRequest request, final AsyncHandler<DeleteAdapterVersionRequest, DeleteAdapterVersionResult> asyncHandler) {
        final DeleteAdapterVersionRequest finalRequest = (DeleteAdapterVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteAdapterVersionResult>(){

            @Override
            public DeleteAdapterVersionResult call() throws Exception {
                DeleteAdapterVersionResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeDeleteAdapterVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetectDocumentTextResult> detectDocumentTextAsync(DetectDocumentTextRequest request) {
        return this.detectDocumentTextAsync(request, null);
    }

    @Override
    public Future<DetectDocumentTextResult> detectDocumentTextAsync(DetectDocumentTextRequest request, final AsyncHandler<DetectDocumentTextRequest, DetectDocumentTextResult> asyncHandler) {
        final DetectDocumentTextRequest finalRequest = (DetectDocumentTextRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetectDocumentTextResult>(){

            @Override
            public DetectDocumentTextResult call() throws Exception {
                DetectDocumentTextResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeDetectDocumentText(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAdapterResult> getAdapterAsync(GetAdapterRequest request) {
        return this.getAdapterAsync(request, null);
    }

    @Override
    public Future<GetAdapterResult> getAdapterAsync(GetAdapterRequest request, final AsyncHandler<GetAdapterRequest, GetAdapterResult> asyncHandler) {
        final GetAdapterRequest finalRequest = (GetAdapterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAdapterResult>(){

            @Override
            public GetAdapterResult call() throws Exception {
                GetAdapterResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetAdapter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAdapterVersionResult> getAdapterVersionAsync(GetAdapterVersionRequest request) {
        return this.getAdapterVersionAsync(request, null);
    }

    @Override
    public Future<GetAdapterVersionResult> getAdapterVersionAsync(GetAdapterVersionRequest request, final AsyncHandler<GetAdapterVersionRequest, GetAdapterVersionResult> asyncHandler) {
        final GetAdapterVersionRequest finalRequest = (GetAdapterVersionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAdapterVersionResult>(){

            @Override
            public GetAdapterVersionResult call() throws Exception {
                GetAdapterVersionResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetAdapterVersion(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentAnalysisResult> getDocumentAnalysisAsync(GetDocumentAnalysisRequest request) {
        return this.getDocumentAnalysisAsync(request, null);
    }

    @Override
    public Future<GetDocumentAnalysisResult> getDocumentAnalysisAsync(GetDocumentAnalysisRequest request, final AsyncHandler<GetDocumentAnalysisRequest, GetDocumentAnalysisResult> asyncHandler) {
        final GetDocumentAnalysisRequest finalRequest = (GetDocumentAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDocumentAnalysisResult>(){

            @Override
            public GetDocumentAnalysisResult call() throws Exception {
                GetDocumentAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetDocumentAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDocumentTextDetectionResult> getDocumentTextDetectionAsync(GetDocumentTextDetectionRequest request) {
        return this.getDocumentTextDetectionAsync(request, null);
    }

    @Override
    public Future<GetDocumentTextDetectionResult> getDocumentTextDetectionAsync(GetDocumentTextDetectionRequest request, final AsyncHandler<GetDocumentTextDetectionRequest, GetDocumentTextDetectionResult> asyncHandler) {
        final GetDocumentTextDetectionRequest finalRequest = (GetDocumentTextDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDocumentTextDetectionResult>(){

            @Override
            public GetDocumentTextDetectionResult call() throws Exception {
                GetDocumentTextDetectionResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetDocumentTextDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetExpenseAnalysisResult> getExpenseAnalysisAsync(GetExpenseAnalysisRequest request) {
        return this.getExpenseAnalysisAsync(request, null);
    }

    @Override
    public Future<GetExpenseAnalysisResult> getExpenseAnalysisAsync(GetExpenseAnalysisRequest request, final AsyncHandler<GetExpenseAnalysisRequest, GetExpenseAnalysisResult> asyncHandler) {
        final GetExpenseAnalysisRequest finalRequest = (GetExpenseAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetExpenseAnalysisResult>(){

            @Override
            public GetExpenseAnalysisResult call() throws Exception {
                GetExpenseAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetExpenseAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLendingAnalysisResult> getLendingAnalysisAsync(GetLendingAnalysisRequest request) {
        return this.getLendingAnalysisAsync(request, null);
    }

    @Override
    public Future<GetLendingAnalysisResult> getLendingAnalysisAsync(GetLendingAnalysisRequest request, final AsyncHandler<GetLendingAnalysisRequest, GetLendingAnalysisResult> asyncHandler) {
        final GetLendingAnalysisRequest finalRequest = (GetLendingAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLendingAnalysisResult>(){

            @Override
            public GetLendingAnalysisResult call() throws Exception {
                GetLendingAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetLendingAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetLendingAnalysisSummaryResult> getLendingAnalysisSummaryAsync(GetLendingAnalysisSummaryRequest request) {
        return this.getLendingAnalysisSummaryAsync(request, null);
    }

    @Override
    public Future<GetLendingAnalysisSummaryResult> getLendingAnalysisSummaryAsync(GetLendingAnalysisSummaryRequest request, final AsyncHandler<GetLendingAnalysisSummaryRequest, GetLendingAnalysisSummaryResult> asyncHandler) {
        final GetLendingAnalysisSummaryRequest finalRequest = (GetLendingAnalysisSummaryRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetLendingAnalysisSummaryResult>(){

            @Override
            public GetLendingAnalysisSummaryResult call() throws Exception {
                GetLendingAnalysisSummaryResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeGetLendingAnalysisSummary(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAdapterVersionsResult> listAdapterVersionsAsync(ListAdapterVersionsRequest request) {
        return this.listAdapterVersionsAsync(request, null);
    }

    @Override
    public Future<ListAdapterVersionsResult> listAdapterVersionsAsync(ListAdapterVersionsRequest request, final AsyncHandler<ListAdapterVersionsRequest, ListAdapterVersionsResult> asyncHandler) {
        final ListAdapterVersionsRequest finalRequest = (ListAdapterVersionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAdapterVersionsResult>(){

            @Override
            public ListAdapterVersionsResult call() throws Exception {
                ListAdapterVersionsResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeListAdapterVersions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAdaptersResult> listAdaptersAsync(ListAdaptersRequest request) {
        return this.listAdaptersAsync(request, null);
    }

    @Override
    public Future<ListAdaptersResult> listAdaptersAsync(ListAdaptersRequest request, final AsyncHandler<ListAdaptersRequest, ListAdaptersResult> asyncHandler) {
        final ListAdaptersRequest finalRequest = (ListAdaptersRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAdaptersResult>(){

            @Override
            public ListAdaptersResult call() throws Exception {
                ListAdaptersResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeListAdapters(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDocumentAnalysisResult> startDocumentAnalysisAsync(StartDocumentAnalysisRequest request) {
        return this.startDocumentAnalysisAsync(request, null);
    }

    @Override
    public Future<StartDocumentAnalysisResult> startDocumentAnalysisAsync(StartDocumentAnalysisRequest request, final AsyncHandler<StartDocumentAnalysisRequest, StartDocumentAnalysisResult> asyncHandler) {
        final StartDocumentAnalysisRequest finalRequest = (StartDocumentAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDocumentAnalysisResult>(){

            @Override
            public StartDocumentAnalysisResult call() throws Exception {
                StartDocumentAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeStartDocumentAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartDocumentTextDetectionResult> startDocumentTextDetectionAsync(StartDocumentTextDetectionRequest request) {
        return this.startDocumentTextDetectionAsync(request, null);
    }

    @Override
    public Future<StartDocumentTextDetectionResult> startDocumentTextDetectionAsync(StartDocumentTextDetectionRequest request, final AsyncHandler<StartDocumentTextDetectionRequest, StartDocumentTextDetectionResult> asyncHandler) {
        final StartDocumentTextDetectionRequest finalRequest = (StartDocumentTextDetectionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartDocumentTextDetectionResult>(){

            @Override
            public StartDocumentTextDetectionResult call() throws Exception {
                StartDocumentTextDetectionResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeStartDocumentTextDetection(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartExpenseAnalysisResult> startExpenseAnalysisAsync(StartExpenseAnalysisRequest request) {
        return this.startExpenseAnalysisAsync(request, null);
    }

    @Override
    public Future<StartExpenseAnalysisResult> startExpenseAnalysisAsync(StartExpenseAnalysisRequest request, final AsyncHandler<StartExpenseAnalysisRequest, StartExpenseAnalysisResult> asyncHandler) {
        final StartExpenseAnalysisRequest finalRequest = (StartExpenseAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartExpenseAnalysisResult>(){

            @Override
            public StartExpenseAnalysisResult call() throws Exception {
                StartExpenseAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeStartExpenseAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartLendingAnalysisResult> startLendingAnalysisAsync(StartLendingAnalysisRequest request) {
        return this.startLendingAnalysisAsync(request, null);
    }

    @Override
    public Future<StartLendingAnalysisResult> startLendingAnalysisAsync(StartLendingAnalysisRequest request, final AsyncHandler<StartLendingAnalysisRequest, StartLendingAnalysisResult> asyncHandler) {
        final StartLendingAnalysisRequest finalRequest = (StartLendingAnalysisRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartLendingAnalysisResult>(){

            @Override
            public StartLendingAnalysisResult call() throws Exception {
                StartLendingAnalysisResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeStartLendingAnalysis(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateAdapterResult> updateAdapterAsync(UpdateAdapterRequest request) {
        return this.updateAdapterAsync(request, null);
    }

    @Override
    public Future<UpdateAdapterResult> updateAdapterAsync(UpdateAdapterRequest request, final AsyncHandler<UpdateAdapterRequest, UpdateAdapterResult> asyncHandler) {
        final UpdateAdapterRequest finalRequest = (UpdateAdapterRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateAdapterResult>(){

            @Override
            public UpdateAdapterResult call() throws Exception {
                UpdateAdapterResult result = null;
                try {
                    result = AmazonTextractAsyncClient.this.executeUpdateAdapter(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

