/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.Adapter;
import com.amazonaws.services.textract.model.transform.AdaptersConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AdaptersConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Adapter> adapters;

    public List<Adapter> getAdapters() {
        return this.adapters;
    }

    public void setAdapters(Collection<Adapter> adapters) {
        if (adapters == null) {
            this.adapters = null;
            return;
        }
        this.adapters = new ArrayList<Adapter>(adapters);
    }

    public AdaptersConfig withAdapters(Adapter ... adapters) {
        if (this.adapters == null) {
            this.setAdapters(new ArrayList<Adapter>(adapters.length));
        }
        for (Adapter ele : adapters) {
            this.adapters.add(ele);
        }
        return this;
    }

    public AdaptersConfig withAdapters(Collection<Adapter> adapters) {
        this.setAdapters(adapters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdapters() != null) {
            sb.append("Adapters: ").append(this.getAdapters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdaptersConfig)) {
            return false;
        }
        AdaptersConfig other = (AdaptersConfig)obj;
        if (other.getAdapters() == null ^ this.getAdapters() == null) {
            return false;
        }
        return other.getAdapters() == null || other.getAdapters().equals(this.getAdapters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdapters() == null ? 0 : this.getAdapters().hashCode());
        return hashCode;
    }

    public AdaptersConfig clone() {
        try {
            return (AdaptersConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AdaptersConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

