/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.NormalizedValue;
import com.amazonaws.services.textract.model.transform.AnalyzeIDDetectionsMarshaller;
import java.io.Serializable;

public class AnalyzeIDDetections
implements Serializable,
Cloneable,
StructuredPojo {
    private String text;
    private NormalizedValue normalizedValue;
    private Float confidence;

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public AnalyzeIDDetections withText(String text) {
        this.setText(text);
        return this;
    }

    public void setNormalizedValue(NormalizedValue normalizedValue) {
        this.normalizedValue = normalizedValue;
    }

    public NormalizedValue getNormalizedValue() {
        return this.normalizedValue;
    }

    public AnalyzeIDDetections withNormalizedValue(NormalizedValue normalizedValue) {
        this.setNormalizedValue(normalizedValue);
        return this;
    }

    public void setConfidence(Float confidence) {
        this.confidence = confidence;
    }

    public Float getConfidence() {
        return this.confidence;
    }

    public AnalyzeIDDetections withConfidence(Float confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getText() != null) {
            sb.append("Text: ").append(this.getText()).append(",");
        }
        if (this.getNormalizedValue() != null) {
            sb.append("NormalizedValue: ").append(this.getNormalizedValue()).append(",");
        }
        if (this.getConfidence() != null) {
            sb.append("Confidence: ").append(this.getConfidence());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeIDDetections)) {
            return false;
        }
        AnalyzeIDDetections other = (AnalyzeIDDetections)obj;
        if (other.getText() == null ^ this.getText() == null) {
            return false;
        }
        if (other.getText() != null && !other.getText().equals(this.getText())) {
            return false;
        }
        if (other.getNormalizedValue() == null ^ this.getNormalizedValue() == null) {
            return false;
        }
        if (other.getNormalizedValue() != null && !other.getNormalizedValue().equals(this.getNormalizedValue())) {
            return false;
        }
        if (other.getConfidence() == null ^ this.getConfidence() == null) {
            return false;
        }
        return other.getConfidence() == null || other.getConfidence().equals(this.getConfidence());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getText() == null ? 0 : this.getText().hashCode());
        hashCode = 31 * hashCode + (this.getNormalizedValue() == null ? 0 : this.getNormalizedValue().hashCode());
        hashCode = 31 * hashCode + (this.getConfidence() == null ? 0 : this.getConfidence().hashCode());
        return hashCode;
    }

    public AnalyzeIDDetections clone() {
        try {
            return (AnalyzeIDDetections)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnalyzeIDDetectionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

