/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.textract.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.textract.model.transform.EvaluationMetricMarshaller;
import java.io.Serializable;

public class EvaluationMetric
implements Serializable,
Cloneable,
StructuredPojo {
    private Float f1Score;
    private Float precision;
    private Float recall;

    public void setF1Score(Float f1Score) {
        this.f1Score = f1Score;
    }

    public Float getF1Score() {
        return this.f1Score;
    }

    public EvaluationMetric withF1Score(Float f1Score) {
        this.setF1Score(f1Score);
        return this;
    }

    public void setPrecision(Float precision) {
        this.precision = precision;
    }

    public Float getPrecision() {
        return this.precision;
    }

    public EvaluationMetric withPrecision(Float precision) {
        this.setPrecision(precision);
        return this;
    }

    public void setRecall(Float recall) {
        this.recall = recall;
    }

    public Float getRecall() {
        return this.recall;
    }

    public EvaluationMetric withRecall(Float recall) {
        this.setRecall(recall);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getF1Score() != null) {
            sb.append("F1Score: ").append(this.getF1Score()).append(",");
        }
        if (this.getPrecision() != null) {
            sb.append("Precision: ").append(this.getPrecision()).append(",");
        }
        if (this.getRecall() != null) {
            sb.append("Recall: ").append(this.getRecall());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationMetric)) {
            return false;
        }
        EvaluationMetric other = (EvaluationMetric)obj;
        if (other.getF1Score() == null ^ this.getF1Score() == null) {
            return false;
        }
        if (other.getF1Score() != null && !other.getF1Score().equals(this.getF1Score())) {
            return false;
        }
        if (other.getPrecision() == null ^ this.getPrecision() == null) {
            return false;
        }
        if (other.getPrecision() != null && !other.getPrecision().equals(this.getPrecision())) {
            return false;
        }
        if (other.getRecall() == null ^ this.getRecall() == null) {
            return false;
        }
        return other.getRecall() == null || other.getRecall().equals(this.getRecall());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getF1Score() == null ? 0 : this.getF1Score().hashCode());
        hashCode = 31 * hashCode + (this.getPrecision() == null ? 0 : this.getPrecision().hashCode());
        hashCode = 31 * hashCode + (this.getRecall() == null ? 0 : this.getRecall().hashCode());
        return hashCode;
    }

    public EvaluationMetric clone() {
        try {
            return (EvaluationMetric)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EvaluationMetricMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

