/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.ContentRedaction;
import com.amazonaws.services.transcribe.model.JobExecutionSettings;
import com.amazonaws.services.transcribe.model.LanguageCode;
import com.amazonaws.services.transcribe.model.LanguageCodeItem;
import com.amazonaws.services.transcribe.model.LanguageIdSettings;
import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.services.transcribe.model.MediaFormat;
import com.amazonaws.services.transcribe.model.ModelSettings;
import com.amazonaws.services.transcribe.model.Settings;
import com.amazonaws.services.transcribe.model.SubtitlesOutput;
import com.amazonaws.services.transcribe.model.Tag;
import com.amazonaws.services.transcribe.model.ToxicityDetectionSettings;
import com.amazonaws.services.transcribe.model.Transcript;
import com.amazonaws.services.transcribe.model.TranscriptionJobStatus;
import com.amazonaws.services.transcribe.model.transform.TranscriptionJobMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranscriptionJob
implements Serializable,
Cloneable,
StructuredPojo {
    private String transcriptionJobName;
    private String transcriptionJobStatus;
    private String languageCode;
    private Integer mediaSampleRateHertz;
    private String mediaFormat;
    private Media media;
    private Transcript transcript;
    private Date startTime;
    private Date creationTime;
    private Date completionTime;
    private String failureReason;
    private Settings settings;
    private ModelSettings modelSettings;
    private JobExecutionSettings jobExecutionSettings;
    private ContentRedaction contentRedaction;
    private Boolean identifyLanguage;
    private Boolean identifyMultipleLanguages;
    private List<String> languageOptions;
    private Float identifiedLanguageScore;
    private List<LanguageCodeItem> languageCodes;
    private List<Tag> tags;
    private SubtitlesOutput subtitles;
    private Map<String, LanguageIdSettings> languageIdSettings;
    private List<ToxicityDetectionSettings> toxicityDetection;

    public void setTranscriptionJobName(String transcriptionJobName) {
        this.transcriptionJobName = transcriptionJobName;
    }

    public String getTranscriptionJobName() {
        return this.transcriptionJobName;
    }

    public TranscriptionJob withTranscriptionJobName(String transcriptionJobName) {
        this.setTranscriptionJobName(transcriptionJobName);
        return this;
    }

    public void setTranscriptionJobStatus(String transcriptionJobStatus) {
        this.transcriptionJobStatus = transcriptionJobStatus;
    }

    public String getTranscriptionJobStatus() {
        return this.transcriptionJobStatus;
    }

    public TranscriptionJob withTranscriptionJobStatus(String transcriptionJobStatus) {
        this.setTranscriptionJobStatus(transcriptionJobStatus);
        return this;
    }

    public TranscriptionJob withTranscriptionJobStatus(TranscriptionJobStatus transcriptionJobStatus) {
        this.transcriptionJobStatus = transcriptionJobStatus.toString();
        return this;
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public TranscriptionJob withLanguageCode(String languageCode) {
        this.setLanguageCode(languageCode);
        return this;
    }

    public TranscriptionJob withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    public void setMediaSampleRateHertz(Integer mediaSampleRateHertz) {
        this.mediaSampleRateHertz = mediaSampleRateHertz;
    }

    public Integer getMediaSampleRateHertz() {
        return this.mediaSampleRateHertz;
    }

    public TranscriptionJob withMediaSampleRateHertz(Integer mediaSampleRateHertz) {
        this.setMediaSampleRateHertz(mediaSampleRateHertz);
        return this;
    }

    public void setMediaFormat(String mediaFormat) {
        this.mediaFormat = mediaFormat;
    }

    public String getMediaFormat() {
        return this.mediaFormat;
    }

    public TranscriptionJob withMediaFormat(String mediaFormat) {
        this.setMediaFormat(mediaFormat);
        return this;
    }

    public TranscriptionJob withMediaFormat(MediaFormat mediaFormat) {
        this.mediaFormat = mediaFormat.toString();
        return this;
    }

    public void setMedia(Media media) {
        this.media = media;
    }

    public Media getMedia() {
        return this.media;
    }

    public TranscriptionJob withMedia(Media media) {
        this.setMedia(media);
        return this;
    }

    public void setTranscript(Transcript transcript) {
        this.transcript = transcript;
    }

    public Transcript getTranscript() {
        return this.transcript;
    }

    public TranscriptionJob withTranscript(Transcript transcript) {
        this.setTranscript(transcript);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public TranscriptionJob withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public TranscriptionJob withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setCompletionTime(Date completionTime) {
        this.completionTime = completionTime;
    }

    public Date getCompletionTime() {
        return this.completionTime;
    }

    public TranscriptionJob withCompletionTime(Date completionTime) {
        this.setCompletionTime(completionTime);
        return this;
    }

    public void setFailureReason(String failureReason) {
        this.failureReason = failureReason;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public TranscriptionJob withFailureReason(String failureReason) {
        this.setFailureReason(failureReason);
        return this;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public TranscriptionJob withSettings(Settings settings) {
        this.setSettings(settings);
        return this;
    }

    public void setModelSettings(ModelSettings modelSettings) {
        this.modelSettings = modelSettings;
    }

    public ModelSettings getModelSettings() {
        return this.modelSettings;
    }

    public TranscriptionJob withModelSettings(ModelSettings modelSettings) {
        this.setModelSettings(modelSettings);
        return this;
    }

    public void setJobExecutionSettings(JobExecutionSettings jobExecutionSettings) {
        this.jobExecutionSettings = jobExecutionSettings;
    }

    public JobExecutionSettings getJobExecutionSettings() {
        return this.jobExecutionSettings;
    }

    public TranscriptionJob withJobExecutionSettings(JobExecutionSettings jobExecutionSettings) {
        this.setJobExecutionSettings(jobExecutionSettings);
        return this;
    }

    public void setContentRedaction(ContentRedaction contentRedaction) {
        this.contentRedaction = contentRedaction;
    }

    public ContentRedaction getContentRedaction() {
        return this.contentRedaction;
    }

    public TranscriptionJob withContentRedaction(ContentRedaction contentRedaction) {
        this.setContentRedaction(contentRedaction);
        return this;
    }

    public void setIdentifyLanguage(Boolean identifyLanguage) {
        this.identifyLanguage = identifyLanguage;
    }

    public Boolean getIdentifyLanguage() {
        return this.identifyLanguage;
    }

    public TranscriptionJob withIdentifyLanguage(Boolean identifyLanguage) {
        this.setIdentifyLanguage(identifyLanguage);
        return this;
    }

    public Boolean isIdentifyLanguage() {
        return this.identifyLanguage;
    }

    public void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
        this.identifyMultipleLanguages = identifyMultipleLanguages;
    }

    public Boolean getIdentifyMultipleLanguages() {
        return this.identifyMultipleLanguages;
    }

    public TranscriptionJob withIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
        this.setIdentifyMultipleLanguages(identifyMultipleLanguages);
        return this;
    }

    public Boolean isIdentifyMultipleLanguages() {
        return this.identifyMultipleLanguages;
    }

    public List<String> getLanguageOptions() {
        return this.languageOptions;
    }

    public void setLanguageOptions(Collection<String> languageOptions) {
        if (languageOptions == null) {
            this.languageOptions = null;
            return;
        }
        this.languageOptions = new ArrayList<String>(languageOptions);
    }

    public TranscriptionJob withLanguageOptions(String ... languageOptions) {
        if (this.languageOptions == null) {
            this.setLanguageOptions(new ArrayList<String>(languageOptions.length));
        }
        for (String ele : languageOptions) {
            this.languageOptions.add(ele);
        }
        return this;
    }

    public TranscriptionJob withLanguageOptions(Collection<String> languageOptions) {
        this.setLanguageOptions(languageOptions);
        return this;
    }

    public TranscriptionJob withLanguageOptions(LanguageCode ... languageOptions) {
        ArrayList<String> languageOptionsCopy = new ArrayList<String>(languageOptions.length);
        for (LanguageCode value : languageOptions) {
            languageOptionsCopy.add(value.toString());
        }
        if (this.getLanguageOptions() == null) {
            this.setLanguageOptions(languageOptionsCopy);
        } else {
            this.getLanguageOptions().addAll(languageOptionsCopy);
        }
        return this;
    }

    public void setIdentifiedLanguageScore(Float identifiedLanguageScore) {
        this.identifiedLanguageScore = identifiedLanguageScore;
    }

    public Float getIdentifiedLanguageScore() {
        return this.identifiedLanguageScore;
    }

    public TranscriptionJob withIdentifiedLanguageScore(Float identifiedLanguageScore) {
        this.setIdentifiedLanguageScore(identifiedLanguageScore);
        return this;
    }

    public List<LanguageCodeItem> getLanguageCodes() {
        return this.languageCodes;
    }

    public void setLanguageCodes(Collection<LanguageCodeItem> languageCodes) {
        if (languageCodes == null) {
            this.languageCodes = null;
            return;
        }
        this.languageCodes = new ArrayList<LanguageCodeItem>(languageCodes);
    }

    public TranscriptionJob withLanguageCodes(LanguageCodeItem ... languageCodes) {
        if (this.languageCodes == null) {
            this.setLanguageCodes(new ArrayList<LanguageCodeItem>(languageCodes.length));
        }
        for (LanguageCodeItem ele : languageCodes) {
            this.languageCodes.add(ele);
        }
        return this;
    }

    public TranscriptionJob withLanguageCodes(Collection<LanguageCodeItem> languageCodes) {
        this.setLanguageCodes(languageCodes);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public TranscriptionJob withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public TranscriptionJob withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setSubtitles(SubtitlesOutput subtitles) {
        this.subtitles = subtitles;
    }

    public SubtitlesOutput getSubtitles() {
        return this.subtitles;
    }

    public TranscriptionJob withSubtitles(SubtitlesOutput subtitles) {
        this.setSubtitles(subtitles);
        return this;
    }

    public Map<String, LanguageIdSettings> getLanguageIdSettings() {
        return this.languageIdSettings;
    }

    public void setLanguageIdSettings(Map<String, LanguageIdSettings> languageIdSettings) {
        this.languageIdSettings = languageIdSettings;
    }

    public TranscriptionJob withLanguageIdSettings(Map<String, LanguageIdSettings> languageIdSettings) {
        this.setLanguageIdSettings(languageIdSettings);
        return this;
    }

    public TranscriptionJob addLanguageIdSettingsEntry(String key, LanguageIdSettings value) {
        if (null == this.languageIdSettings) {
            this.languageIdSettings = new HashMap<String, LanguageIdSettings>();
        }
        if (this.languageIdSettings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.languageIdSettings.put(key, value);
        return this;
    }

    public TranscriptionJob clearLanguageIdSettingsEntries() {
        this.languageIdSettings = null;
        return this;
    }

    public List<ToxicityDetectionSettings> getToxicityDetection() {
        return this.toxicityDetection;
    }

    public void setToxicityDetection(Collection<ToxicityDetectionSettings> toxicityDetection) {
        if (toxicityDetection == null) {
            this.toxicityDetection = null;
            return;
        }
        this.toxicityDetection = new ArrayList<ToxicityDetectionSettings>(toxicityDetection);
    }

    public TranscriptionJob withToxicityDetection(ToxicityDetectionSettings ... toxicityDetection) {
        if (this.toxicityDetection == null) {
            this.setToxicityDetection(new ArrayList<ToxicityDetectionSettings>(toxicityDetection.length));
        }
        for (ToxicityDetectionSettings ele : toxicityDetection) {
            this.toxicityDetection.add(ele);
        }
        return this;
    }

    public TranscriptionJob withToxicityDetection(Collection<ToxicityDetectionSettings> toxicityDetection) {
        this.setToxicityDetection(toxicityDetection);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTranscriptionJobName() != null) {
            sb.append("TranscriptionJobName: ").append(this.getTranscriptionJobName()).append(",");
        }
        if (this.getTranscriptionJobStatus() != null) {
            sb.append("TranscriptionJobStatus: ").append(this.getTranscriptionJobStatus()).append(",");
        }
        if (this.getLanguageCode() != null) {
            sb.append("LanguageCode: ").append(this.getLanguageCode()).append(",");
        }
        if (this.getMediaSampleRateHertz() != null) {
            sb.append("MediaSampleRateHertz: ").append(this.getMediaSampleRateHertz()).append(",");
        }
        if (this.getMediaFormat() != null) {
            sb.append("MediaFormat: ").append(this.getMediaFormat()).append(",");
        }
        if (this.getMedia() != null) {
            sb.append("Media: ").append(this.getMedia()).append(",");
        }
        if (this.getTranscript() != null) {
            sb.append("Transcript: ").append(this.getTranscript()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getCompletionTime() != null) {
            sb.append("CompletionTime: ").append(this.getCompletionTime()).append(",");
        }
        if (this.getFailureReason() != null) {
            sb.append("FailureReason: ").append(this.getFailureReason()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getModelSettings() != null) {
            sb.append("ModelSettings: ").append(this.getModelSettings()).append(",");
        }
        if (this.getJobExecutionSettings() != null) {
            sb.append("JobExecutionSettings: ").append(this.getJobExecutionSettings()).append(",");
        }
        if (this.getContentRedaction() != null) {
            sb.append("ContentRedaction: ").append(this.getContentRedaction()).append(",");
        }
        if (this.getIdentifyLanguage() != null) {
            sb.append("IdentifyLanguage: ").append(this.getIdentifyLanguage()).append(",");
        }
        if (this.getIdentifyMultipleLanguages() != null) {
            sb.append("IdentifyMultipleLanguages: ").append(this.getIdentifyMultipleLanguages()).append(",");
        }
        if (this.getLanguageOptions() != null) {
            sb.append("LanguageOptions: ").append(this.getLanguageOptions()).append(",");
        }
        if (this.getIdentifiedLanguageScore() != null) {
            sb.append("IdentifiedLanguageScore: ").append(this.getIdentifiedLanguageScore()).append(",");
        }
        if (this.getLanguageCodes() != null) {
            sb.append("LanguageCodes: ").append(this.getLanguageCodes()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSubtitles() != null) {
            sb.append("Subtitles: ").append(this.getSubtitles()).append(",");
        }
        if (this.getLanguageIdSettings() != null) {
            sb.append("LanguageIdSettings: ").append(this.getLanguageIdSettings()).append(",");
        }
        if (this.getToxicityDetection() != null) {
            sb.append("ToxicityDetection: ").append(this.getToxicityDetection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranscriptionJob)) {
            return false;
        }
        TranscriptionJob other = (TranscriptionJob)obj;
        if (other.getTranscriptionJobName() == null ^ this.getTranscriptionJobName() == null) {
            return false;
        }
        if (other.getTranscriptionJobName() != null && !other.getTranscriptionJobName().equals(this.getTranscriptionJobName())) {
            return false;
        }
        if (other.getTranscriptionJobStatus() == null ^ this.getTranscriptionJobStatus() == null) {
            return false;
        }
        if (other.getTranscriptionJobStatus() != null && !other.getTranscriptionJobStatus().equals(this.getTranscriptionJobStatus())) {
            return false;
        }
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null) {
            return false;
        }
        if (other.getLanguageCode() != null && !other.getLanguageCode().equals(this.getLanguageCode())) {
            return false;
        }
        if (other.getMediaSampleRateHertz() == null ^ this.getMediaSampleRateHertz() == null) {
            return false;
        }
        if (other.getMediaSampleRateHertz() != null && !other.getMediaSampleRateHertz().equals(this.getMediaSampleRateHertz())) {
            return false;
        }
        if (other.getMediaFormat() == null ^ this.getMediaFormat() == null) {
            return false;
        }
        if (other.getMediaFormat() != null && !other.getMediaFormat().equals(this.getMediaFormat())) {
            return false;
        }
        if (other.getMedia() == null ^ this.getMedia() == null) {
            return false;
        }
        if (other.getMedia() != null && !other.getMedia().equals(this.getMedia())) {
            return false;
        }
        if (other.getTranscript() == null ^ this.getTranscript() == null) {
            return false;
        }
        if (other.getTranscript() != null && !other.getTranscript().equals(this.getTranscript())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getCompletionTime() == null ^ this.getCompletionTime() == null) {
            return false;
        }
        if (other.getCompletionTime() != null && !other.getCompletionTime().equals(this.getCompletionTime())) {
            return false;
        }
        if (other.getFailureReason() == null ^ this.getFailureReason() == null) {
            return false;
        }
        if (other.getFailureReason() != null && !other.getFailureReason().equals(this.getFailureReason())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getModelSettings() == null ^ this.getModelSettings() == null) {
            return false;
        }
        if (other.getModelSettings() != null && !other.getModelSettings().equals(this.getModelSettings())) {
            return false;
        }
        if (other.getJobExecutionSettings() == null ^ this.getJobExecutionSettings() == null) {
            return false;
        }
        if (other.getJobExecutionSettings() != null && !other.getJobExecutionSettings().equals(this.getJobExecutionSettings())) {
            return false;
        }
        if (other.getContentRedaction() == null ^ this.getContentRedaction() == null) {
            return false;
        }
        if (other.getContentRedaction() != null && !other.getContentRedaction().equals(this.getContentRedaction())) {
            return false;
        }
        if (other.getIdentifyLanguage() == null ^ this.getIdentifyLanguage() == null) {
            return false;
        }
        if (other.getIdentifyLanguage() != null && !other.getIdentifyLanguage().equals(this.getIdentifyLanguage())) {
            return false;
        }
        if (other.getIdentifyMultipleLanguages() == null ^ this.getIdentifyMultipleLanguages() == null) {
            return false;
        }
        if (other.getIdentifyMultipleLanguages() != null && !other.getIdentifyMultipleLanguages().equals(this.getIdentifyMultipleLanguages())) {
            return false;
        }
        if (other.getLanguageOptions() == null ^ this.getLanguageOptions() == null) {
            return false;
        }
        if (other.getLanguageOptions() != null && !other.getLanguageOptions().equals(this.getLanguageOptions())) {
            return false;
        }
        if (other.getIdentifiedLanguageScore() == null ^ this.getIdentifiedLanguageScore() == null) {
            return false;
        }
        if (other.getIdentifiedLanguageScore() != null && !other.getIdentifiedLanguageScore().equals(this.getIdentifiedLanguageScore())) {
            return false;
        }
        if (other.getLanguageCodes() == null ^ this.getLanguageCodes() == null) {
            return false;
        }
        if (other.getLanguageCodes() != null && !other.getLanguageCodes().equals(this.getLanguageCodes())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSubtitles() == null ^ this.getSubtitles() == null) {
            return false;
        }
        if (other.getSubtitles() != null && !other.getSubtitles().equals(this.getSubtitles())) {
            return false;
        }
        if (other.getLanguageIdSettings() == null ^ this.getLanguageIdSettings() == null) {
            return false;
        }
        if (other.getLanguageIdSettings() != null && !other.getLanguageIdSettings().equals(this.getLanguageIdSettings())) {
            return false;
        }
        if (other.getToxicityDetection() == null ^ this.getToxicityDetection() == null) {
            return false;
        }
        return other.getToxicityDetection() == null || other.getToxicityDetection().equals(this.getToxicityDetection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTranscriptionJobName() == null ? 0 : this.getTranscriptionJobName().hashCode());
        hashCode = 31 * hashCode + (this.getTranscriptionJobStatus() == null ? 0 : this.getTranscriptionJobStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCode() == null ? 0 : this.getLanguageCode().hashCode());
        hashCode = 31 * hashCode + (this.getMediaSampleRateHertz() == null ? 0 : this.getMediaSampleRateHertz().hashCode());
        hashCode = 31 * hashCode + (this.getMediaFormat() == null ? 0 : this.getMediaFormat().hashCode());
        hashCode = 31 * hashCode + (this.getMedia() == null ? 0 : this.getMedia().hashCode());
        hashCode = 31 * hashCode + (this.getTranscript() == null ? 0 : this.getTranscript().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getCompletionTime() == null ? 0 : this.getCompletionTime().hashCode());
        hashCode = 31 * hashCode + (this.getFailureReason() == null ? 0 : this.getFailureReason().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getModelSettings() == null ? 0 : this.getModelSettings().hashCode());
        hashCode = 31 * hashCode + (this.getJobExecutionSettings() == null ? 0 : this.getJobExecutionSettings().hashCode());
        hashCode = 31 * hashCode + (this.getContentRedaction() == null ? 0 : this.getContentRedaction().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifyLanguage() == null ? 0 : this.getIdentifyLanguage().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifyMultipleLanguages() == null ? 0 : this.getIdentifyMultipleLanguages().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageOptions() == null ? 0 : this.getLanguageOptions().hashCode());
        hashCode = 31 * hashCode + (this.getIdentifiedLanguageScore() == null ? 0 : this.getIdentifiedLanguageScore().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageCodes() == null ? 0 : this.getLanguageCodes().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSubtitles() == null ? 0 : this.getSubtitles().hashCode());
        hashCode = 31 * hashCode + (this.getLanguageIdSettings() == null ? 0 : this.getLanguageIdSettings().hashCode());
        hashCode = 31 * hashCode + (this.getToxicityDetection() == null ? 0 : this.getToxicityDetection().hashCode());
        return hashCode;
    }

    public TranscriptionJob clone() {
        try {
            return (TranscriptionJob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TranscriptionJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

