/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.transcribe.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.transcribe.model.MedicalScribeJob;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class MedicalScribeJobMarshaller {
    private static final MarshallingInfo<String> MEDICALSCRIBEJOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MedicalScribeJobName").build();
    private static final MarshallingInfo<String> MEDICALSCRIBEJOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MedicalScribeJobStatus").build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LanguageCode").build();
    private static final MarshallingInfo<StructuredPojo> MEDIA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Media").build();
    private static final MarshallingInfo<StructuredPojo> MEDICALSCRIBEOUTPUT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MedicalScribeOutput").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> FAILUREREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureReason").build();
    private static final MarshallingInfo<StructuredPojo> SETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Settings").build();
    private static final MarshallingInfo<String> DATAACCESSROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DataAccessRoleArn").build();
    private static final MarshallingInfo<List> CHANNELDEFINITIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ChannelDefinitions").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MedicalScribeJobMarshaller instance = new MedicalScribeJobMarshaller();

    public static MedicalScribeJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(MedicalScribeJob medicalScribeJob, ProtocolMarshaller protocolMarshaller) {
        if (medicalScribeJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)medicalScribeJob.getMedicalScribeJobName(), MEDICALSCRIBEJOBNAME_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getMedicalScribeJobStatus(), MEDICALSCRIBEJOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getLanguageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getMedia(), MEDIA_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getMedicalScribeOutput(), MEDICALSCRIBEOUTPUT_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getCompletionTime(), COMPLETIONTIME_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getFailureReason(), FAILUREREASON_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getSettings(), SETTINGS_BINDING);
            protocolMarshaller.marshall((Object)medicalScribeJob.getDataAccessRoleArn(), DATAACCESSROLEARN_BINDING);
            protocolMarshaller.marshall(medicalScribeJob.getChannelDefinitions(), CHANNELDEFINITIONS_BINDING);
            protocolMarshaller.marshall(medicalScribeJob.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

