/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.transcribe;

import javax.annotation.Generated;

import com.amazonaws.services.transcribe.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonTranscribe}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonTranscribe implements AmazonTranscribe {

    protected AbstractAmazonTranscribe() {
    }

    @Override
    public CreateCallAnalyticsCategoryResult createCallAnalyticsCategory(CreateCallAnalyticsCategoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateLanguageModelResult createLanguageModel(CreateLanguageModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateMedicalVocabularyResult createMedicalVocabulary(CreateMedicalVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVocabularyResult createVocabulary(CreateVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateVocabularyFilterResult createVocabularyFilter(CreateVocabularyFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCallAnalyticsCategoryResult deleteCallAnalyticsCategory(DeleteCallAnalyticsCategoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCallAnalyticsJobResult deleteCallAnalyticsJob(DeleteCallAnalyticsJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLanguageModelResult deleteLanguageModel(DeleteLanguageModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMedicalScribeJobResult deleteMedicalScribeJob(DeleteMedicalScribeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMedicalTranscriptionJobResult deleteMedicalTranscriptionJob(DeleteMedicalTranscriptionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteMedicalVocabularyResult deleteMedicalVocabulary(DeleteMedicalVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTranscriptionJobResult deleteTranscriptionJob(DeleteTranscriptionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVocabularyResult deleteVocabulary(DeleteVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteVocabularyFilterResult deleteVocabularyFilter(DeleteVocabularyFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeLanguageModelResult describeLanguageModel(DescribeLanguageModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCallAnalyticsCategoryResult getCallAnalyticsCategory(GetCallAnalyticsCategoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCallAnalyticsJobResult getCallAnalyticsJob(GetCallAnalyticsJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMedicalScribeJobResult getMedicalScribeJob(GetMedicalScribeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMedicalTranscriptionJobResult getMedicalTranscriptionJob(GetMedicalTranscriptionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetMedicalVocabularyResult getMedicalVocabulary(GetMedicalVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTranscriptionJobResult getTranscriptionJob(GetTranscriptionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVocabularyResult getVocabulary(GetVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetVocabularyFilterResult getVocabularyFilter(GetVocabularyFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCallAnalyticsCategoriesResult listCallAnalyticsCategories(ListCallAnalyticsCategoriesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCallAnalyticsJobsResult listCallAnalyticsJobs(ListCallAnalyticsJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLanguageModelsResult listLanguageModels(ListLanguageModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMedicalScribeJobsResult listMedicalScribeJobs(ListMedicalScribeJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMedicalTranscriptionJobsResult listMedicalTranscriptionJobs(ListMedicalTranscriptionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListMedicalVocabulariesResult listMedicalVocabularies(ListMedicalVocabulariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTranscriptionJobsResult listTranscriptionJobs(ListTranscriptionJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVocabulariesResult listVocabularies(ListVocabulariesRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListVocabularyFiltersResult listVocabularyFilters(ListVocabularyFiltersRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartCallAnalyticsJobResult startCallAnalyticsJob(StartCallAnalyticsJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMedicalScribeJobResult startMedicalScribeJob(StartMedicalScribeJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartMedicalTranscriptionJobResult startMedicalTranscriptionJob(StartMedicalTranscriptionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartTranscriptionJobResult startTranscriptionJob(StartTranscriptionJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCallAnalyticsCategoryResult updateCallAnalyticsCategory(UpdateCallAnalyticsCategoryRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateMedicalVocabularyResult updateMedicalVocabulary(UpdateMedicalVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVocabularyResult updateVocabulary(UpdateVocabularyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateVocabularyFilterResult updateVocabularyFilter(UpdateVocabularyFilterRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
