/*
 * Copyright 2016-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.wafv2;

import javax.annotation.Generated;

import com.amazonaws.services.wafv2.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSWAFV2}. Convenient method forms pass through to the corresponding overload that
 * takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSWAFV2 implements AWSWAFV2 {

    protected AbstractAWSWAFV2() {
    }

    @Override
    public AssociateWebACLResult associateWebACL(AssociateWebACLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CheckCapacityResult checkCapacity(CheckCapacityRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateIPSetResult createIPSet(CreateIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRegexPatternSetResult createRegexPatternSet(CreateRegexPatternSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateRuleGroupResult createRuleGroup(CreateRuleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateWebACLResult createWebACL(CreateWebACLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteFirewallManagerRuleGroupsResult deleteFirewallManagerRuleGroups(DeleteFirewallManagerRuleGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteIPSetResult deleteIPSet(DeleteIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteLoggingConfigurationResult deleteLoggingConfiguration(DeleteLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeletePermissionPolicyResult deletePermissionPolicy(DeletePermissionPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRegexPatternSetResult deleteRegexPatternSet(DeleteRegexPatternSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteRuleGroupResult deleteRuleGroup(DeleteRuleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteWebACLResult deleteWebACL(DeleteWebACLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeManagedRuleGroupResult describeManagedRuleGroup(DescribeManagedRuleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DisassociateWebACLResult disassociateWebACL(DisassociateWebACLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetIPSetResult getIPSet(GetIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetLoggingConfigurationResult getLoggingConfiguration(GetLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetPermissionPolicyResult getPermissionPolicy(GetPermissionPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRateBasedStatementManagedKeysResult getRateBasedStatementManagedKeys(GetRateBasedStatementManagedKeysRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRegexPatternSetResult getRegexPatternSet(GetRegexPatternSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetRuleGroupResult getRuleGroup(GetRuleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetSampledRequestsResult getSampledRequests(GetSampledRequestsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWebACLResult getWebACL(GetWebACLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetWebACLForResourceResult getWebACLForResource(GetWebACLForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAvailableManagedRuleGroupsResult listAvailableManagedRuleGroups(ListAvailableManagedRuleGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListIPSetsResult listIPSets(ListIPSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListLoggingConfigurationsResult listLoggingConfigurations(ListLoggingConfigurationsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRegexPatternSetsResult listRegexPatternSets(ListRegexPatternSetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListResourcesForWebACLResult listResourcesForWebACL(ListResourcesForWebACLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListRuleGroupsResult listRuleGroups(ListRuleGroupsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListWebACLsResult listWebACLs(ListWebACLsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutLoggingConfigurationResult putLoggingConfiguration(PutLoggingConfigurationRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutPermissionPolicyResult putPermissionPolicy(PutPermissionPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateIPSetResult updateIPSet(UpdateIPSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRegexPatternSetResult updateRegexPatternSet(UpdateRegexPatternSetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateRuleGroupResult updateRuleGroup(UpdateRuleGroupRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateWebACLResult updateWebACL(UpdateWebACLRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
