/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.wafv2.model.Label;
import com.amazonaws.services.wafv2.model.OverrideAction;
import com.amazonaws.services.wafv2.model.RuleAction;
import com.amazonaws.services.wafv2.model.Statement;
import com.amazonaws.services.wafv2.model.VisibilityConfig;
import com.amazonaws.services.wafv2.model.transform.RuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Rule
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private Integer priority;
    private Statement statement;
    private RuleAction action;
    private OverrideAction overrideAction;
    private List<Label> ruleLabels;
    private VisibilityConfig visibilityConfig;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Rule withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Rule withPriority(Integer priority) {
        this.setPriority(priority);
        return this;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public Rule withStatement(Statement statement) {
        this.setStatement(statement);
        return this;
    }

    public void setAction(RuleAction action) {
        this.action = action;
    }

    public RuleAction getAction() {
        return this.action;
    }

    public Rule withAction(RuleAction action) {
        this.setAction(action);
        return this;
    }

    public void setOverrideAction(OverrideAction overrideAction) {
        this.overrideAction = overrideAction;
    }

    public OverrideAction getOverrideAction() {
        return this.overrideAction;
    }

    public Rule withOverrideAction(OverrideAction overrideAction) {
        this.setOverrideAction(overrideAction);
        return this;
    }

    public List<Label> getRuleLabels() {
        return this.ruleLabels;
    }

    public void setRuleLabels(Collection<Label> ruleLabels) {
        if (ruleLabels == null) {
            this.ruleLabels = null;
            return;
        }
        this.ruleLabels = new ArrayList<Label>(ruleLabels);
    }

    public Rule withRuleLabels(Label ... ruleLabels) {
        if (this.ruleLabels == null) {
            this.setRuleLabels(new ArrayList<Label>(ruleLabels.length));
        }
        for (Label ele : ruleLabels) {
            this.ruleLabels.add(ele);
        }
        return this;
    }

    public Rule withRuleLabels(Collection<Label> ruleLabels) {
        this.setRuleLabels(ruleLabels);
        return this;
    }

    public void setVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.visibilityConfig = visibilityConfig;
    }

    public VisibilityConfig getVisibilityConfig() {
        return this.visibilityConfig;
    }

    public Rule withVisibilityConfig(VisibilityConfig visibilityConfig) {
        this.setVisibilityConfig(visibilityConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPriority() != null) {
            sb.append("Priority: ").append(this.getPriority()).append(",");
        }
        if (this.getStatement() != null) {
            sb.append("Statement: ").append(this.getStatement()).append(",");
        }
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getOverrideAction() != null) {
            sb.append("OverrideAction: ").append(this.getOverrideAction()).append(",");
        }
        if (this.getRuleLabels() != null) {
            sb.append("RuleLabels: ").append(this.getRuleLabels()).append(",");
        }
        if (this.getVisibilityConfig() != null) {
            sb.append("VisibilityConfig: ").append(this.getVisibilityConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPriority() == null ^ this.getPriority() == null) {
            return false;
        }
        if (other.getPriority() != null && !other.getPriority().equals(this.getPriority())) {
            return false;
        }
        if (other.getStatement() == null ^ this.getStatement() == null) {
            return false;
        }
        if (other.getStatement() != null && !other.getStatement().equals(this.getStatement())) {
            return false;
        }
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getOverrideAction() == null ^ this.getOverrideAction() == null) {
            return false;
        }
        if (other.getOverrideAction() != null && !other.getOverrideAction().equals(this.getOverrideAction())) {
            return false;
        }
        if (other.getRuleLabels() == null ^ this.getRuleLabels() == null) {
            return false;
        }
        if (other.getRuleLabels() != null && !other.getRuleLabels().equals(this.getRuleLabels())) {
            return false;
        }
        if (other.getVisibilityConfig() == null ^ this.getVisibilityConfig() == null) {
            return false;
        }
        return other.getVisibilityConfig() == null || other.getVisibilityConfig().equals(this.getVisibilityConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPriority() == null ? 0 : this.getPriority().hashCode());
        hashCode = 31 * hashCode + (this.getStatement() == null ? 0 : this.getStatement().hashCode());
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getOverrideAction() == null ? 0 : this.getOverrideAction().hashCode());
        hashCode = 31 * hashCode + (this.getRuleLabels() == null ? 0 : this.getRuleLabels().hashCode());
        hashCode = 31 * hashCode + (this.getVisibilityConfig() == null ? 0 : this.getVisibilityConfig().hashCode());
        return hashCode;
    }

    public Rule clone() {
        try {
            return (Rule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

