/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.wafv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.wafv2.model.Scope;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAPIKeyRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String scope;
    private List<String> tokenDomains;

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public CreateAPIKeyRequest withScope(String scope) {
        this.setScope(scope);
        return this;
    }

    public CreateAPIKeyRequest withScope(Scope scope) {
        this.scope = scope.toString();
        return this;
    }

    public List<String> getTokenDomains() {
        return this.tokenDomains;
    }

    public void setTokenDomains(Collection<String> tokenDomains) {
        if (tokenDomains == null) {
            this.tokenDomains = null;
            return;
        }
        this.tokenDomains = new ArrayList<String>(tokenDomains);
    }

    public CreateAPIKeyRequest withTokenDomains(String ... tokenDomains) {
        if (this.tokenDomains == null) {
            this.setTokenDomains(new ArrayList<String>(tokenDomains.length));
        }
        for (String ele : tokenDomains) {
            this.tokenDomains.add(ele);
        }
        return this;
    }

    public CreateAPIKeyRequest withTokenDomains(Collection<String> tokenDomains) {
        this.setTokenDomains(tokenDomains);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getScope() != null) {
            sb.append("Scope: ").append(this.getScope()).append(",");
        }
        if (this.getTokenDomains() != null) {
            sb.append("TokenDomains: ").append(this.getTokenDomains());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAPIKeyRequest)) {
            return false;
        }
        CreateAPIKeyRequest other = (CreateAPIKeyRequest)obj;
        if (other.getScope() == null ^ this.getScope() == null) {
            return false;
        }
        if (other.getScope() != null && !other.getScope().equals(this.getScope())) {
            return false;
        }
        if (other.getTokenDomains() == null ^ this.getTokenDomains() == null) {
            return false;
        }
        return other.getTokenDomains() == null || other.getTokenDomains().equals(this.getTokenDomains());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getScope() == null ? 0 : this.getScope().hashCode());
        hashCode = 31 * hashCode + (this.getTokenDomains() == null ? 0 : this.getTokenDomains().hashCode());
        return hashCode;
    }

    public CreateAPIKeyRequest clone() {
        return (CreateAPIKeyRequest)super.clone();
    }
}

