/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workmailmessageflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workmailmessageflow.model.transform.S3ReferenceMarshaller;
import java.io.Serializable;

public class S3Reference
implements Serializable,
Cloneable,
StructuredPojo {
    private String bucket;
    private String key;
    private String objectVersion;

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getBucket() {
        return this.bucket;
    }

    public S3Reference withBucket(String bucket) {
        this.setBucket(bucket);
        return this;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public S3Reference withKey(String key) {
        this.setKey(key);
        return this;
    }

    public void setObjectVersion(String objectVersion) {
        this.objectVersion = objectVersion;
    }

    public String getObjectVersion() {
        return this.objectVersion;
    }

    public S3Reference withObjectVersion(String objectVersion) {
        this.setObjectVersion(objectVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: ").append(this.getBucket()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getObjectVersion() != null) {
            sb.append("ObjectVersion: ").append(this.getObjectVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Reference)) {
            return false;
        }
        S3Reference other = (S3Reference)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getObjectVersion() == null ^ this.getObjectVersion() == null) {
            return false;
        }
        return other.getObjectVersion() == null || other.getObjectVersion().equals(this.getObjectVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getObjectVersion() == null ? 0 : this.getObjectVersion().hashCode());
        return hashCode;
    }

    public S3Reference clone() {
        try {
            return (S3Reference)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ReferenceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

