/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.WorkspaceDirectory;
import com.amazonaws.services.workspaces.model.transform.DefaultWorkspaceCreationPropertiesJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class WorkspaceDirectoryJsonMarshaller {
    private static WorkspaceDirectoryJsonMarshaller instance;

    public void marshall(WorkspaceDirectory workspaceDirectory, JSONWriter jsonWriter) {
        if (workspaceDirectory == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList dnsIpAddressesList;
            SdkInternalList subnetIdsList;
            jsonWriter.object();
            if (workspaceDirectory.getDirectoryId() != null) {
                jsonWriter.key("DirectoryId").value((Object)workspaceDirectory.getDirectoryId());
            }
            if (workspaceDirectory.getAlias() != null) {
                jsonWriter.key("Alias").value((Object)workspaceDirectory.getAlias());
            }
            if (workspaceDirectory.getDirectoryName() != null) {
                jsonWriter.key("DirectoryName").value((Object)workspaceDirectory.getDirectoryName());
            }
            if (workspaceDirectory.getRegistrationCode() != null) {
                jsonWriter.key("RegistrationCode").value((Object)workspaceDirectory.getRegistrationCode());
            }
            if (!(subnetIdsList = (SdkInternalList)workspaceDirectory.getSubnetIds()).isEmpty() || !subnetIdsList.isAutoConstruct()) {
                jsonWriter.key("SubnetIds");
                jsonWriter.array();
                for (String subnetIdsListValue : subnetIdsList) {
                    if (subnetIdsListValue == null) continue;
                    jsonWriter.value((Object)subnetIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!(dnsIpAddressesList = (SdkInternalList)workspaceDirectory.getDnsIpAddresses()).isEmpty() || !dnsIpAddressesList.isAutoConstruct()) {
                jsonWriter.key("DnsIpAddresses");
                jsonWriter.array();
                for (String dnsIpAddressesListValue : dnsIpAddressesList) {
                    if (dnsIpAddressesListValue == null) continue;
                    jsonWriter.value((Object)dnsIpAddressesListValue);
                }
                jsonWriter.endArray();
            }
            if (workspaceDirectory.getCustomerUserName() != null) {
                jsonWriter.key("CustomerUserName").value((Object)workspaceDirectory.getCustomerUserName());
            }
            if (workspaceDirectory.getIamRoleId() != null) {
                jsonWriter.key("IamRoleId").value((Object)workspaceDirectory.getIamRoleId());
            }
            if (workspaceDirectory.getDirectoryType() != null) {
                jsonWriter.key("DirectoryType").value((Object)workspaceDirectory.getDirectoryType());
            }
            if (workspaceDirectory.getWorkspaceSecurityGroupId() != null) {
                jsonWriter.key("WorkspaceSecurityGroupId").value((Object)workspaceDirectory.getWorkspaceSecurityGroupId());
            }
            if (workspaceDirectory.getState() != null) {
                jsonWriter.key("State").value((Object)workspaceDirectory.getState());
            }
            if (workspaceDirectory.getWorkspaceCreationProperties() != null) {
                jsonWriter.key("WorkspaceCreationProperties");
                DefaultWorkspaceCreationPropertiesJsonMarshaller.getInstance().marshall(workspaceDirectory.getWorkspaceCreationProperties(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static WorkspaceDirectoryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new WorkspaceDirectoryJsonMarshaller();
        }
        return instance;
    }
}

