/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.Application;
import com.amazonaws.services.workspaces.model.Tag;
import com.amazonaws.services.workspaces.model.WorkspaceImageIngestionProcess;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImportWorkspaceImageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String ec2ImageId;
    private String ingestionProcess;
    private String imageName;
    private String imageDescription;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<String> applications;

    public void setEc2ImageId(String ec2ImageId) {
        this.ec2ImageId = ec2ImageId;
    }

    public String getEc2ImageId() {
        return this.ec2ImageId;
    }

    public ImportWorkspaceImageRequest withEc2ImageId(String ec2ImageId) {
        this.setEc2ImageId(ec2ImageId);
        return this;
    }

    public void setIngestionProcess(String ingestionProcess) {
        this.ingestionProcess = ingestionProcess;
    }

    public String getIngestionProcess() {
        return this.ingestionProcess;
    }

    public ImportWorkspaceImageRequest withIngestionProcess(String ingestionProcess) {
        this.setIngestionProcess(ingestionProcess);
        return this;
    }

    public ImportWorkspaceImageRequest withIngestionProcess(WorkspaceImageIngestionProcess ingestionProcess) {
        this.ingestionProcess = ingestionProcess.toString();
        return this;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public ImportWorkspaceImageRequest withImageName(String imageName) {
        this.setImageName(imageName);
        return this;
    }

    public void setImageDescription(String imageDescription) {
        this.imageDescription = imageDescription;
    }

    public String getImageDescription() {
        return this.imageDescription;
    }

    public ImportWorkspaceImageRequest withImageDescription(String imageDescription) {
        this.setImageDescription(imageDescription);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public ImportWorkspaceImageRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public ImportWorkspaceImageRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<String> getApplications() {
        if (this.applications == null) {
            this.applications = new SdkInternalList();
        }
        return this.applications;
    }

    public void setApplications(Collection<String> applications) {
        if (applications == null) {
            this.applications = null;
            return;
        }
        this.applications = new SdkInternalList(applications);
    }

    public ImportWorkspaceImageRequest withApplications(String ... applications) {
        if (this.applications == null) {
            this.setApplications((Collection<String>)new SdkInternalList(applications.length));
        }
        for (String ele : applications) {
            this.applications.add((Object)ele);
        }
        return this;
    }

    public ImportWorkspaceImageRequest withApplications(Collection<String> applications) {
        this.setApplications(applications);
        return this;
    }

    public ImportWorkspaceImageRequest withApplications(Application ... applications) {
        SdkInternalList applicationsCopy = new SdkInternalList(applications.length);
        for (Application value : applications) {
            applicationsCopy.add((Object)value.toString());
        }
        if (this.getApplications() == null) {
            this.setApplications((Collection<String>)applicationsCopy);
        } else {
            this.getApplications().addAll((Collection<String>)applicationsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEc2ImageId() != null) {
            sb.append("Ec2ImageId: ").append(this.getEc2ImageId()).append(",");
        }
        if (this.getIngestionProcess() != null) {
            sb.append("IngestionProcess: ").append(this.getIngestionProcess()).append(",");
        }
        if (this.getImageName() != null) {
            sb.append("ImageName: ").append(this.getImageName()).append(",");
        }
        if (this.getImageDescription() != null) {
            sb.append("ImageDescription: ").append(this.getImageDescription()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getApplications() != null) {
            sb.append("Applications: ").append(this.getApplications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportWorkspaceImageRequest)) {
            return false;
        }
        ImportWorkspaceImageRequest other = (ImportWorkspaceImageRequest)obj;
        if (other.getEc2ImageId() == null ^ this.getEc2ImageId() == null) {
            return false;
        }
        if (other.getEc2ImageId() != null && !other.getEc2ImageId().equals(this.getEc2ImageId())) {
            return false;
        }
        if (other.getIngestionProcess() == null ^ this.getIngestionProcess() == null) {
            return false;
        }
        if (other.getIngestionProcess() != null && !other.getIngestionProcess().equals(this.getIngestionProcess())) {
            return false;
        }
        if (other.getImageName() == null ^ this.getImageName() == null) {
            return false;
        }
        if (other.getImageName() != null && !other.getImageName().equals(this.getImageName())) {
            return false;
        }
        if (other.getImageDescription() == null ^ this.getImageDescription() == null) {
            return false;
        }
        if (other.getImageDescription() != null && !other.getImageDescription().equals(this.getImageDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getApplications() == null ^ this.getApplications() == null) {
            return false;
        }
        return other.getApplications() == null || other.getApplications().equals(this.getApplications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEc2ImageId() == null ? 0 : this.getEc2ImageId().hashCode());
        hashCode = 31 * hashCode + (this.getIngestionProcess() == null ? 0 : this.getIngestionProcess().hashCode());
        hashCode = 31 * hashCode + (this.getImageName() == null ? 0 : this.getImageName().hashCode());
        hashCode = 31 * hashCode + (this.getImageDescription() == null ? 0 : this.getImageDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getApplications() == null ? 0 : this.getApplications().hashCode());
        return hashCode;
    }

    public ImportWorkspaceImageRequest clone() {
        return (ImportWorkspaceImageRequest)super.clone();
    }
}

