/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.workspaces.model.IpRuleItem;
import com.amazonaws.services.workspaces.model.transform.WorkspacesIpGroupMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class WorkspacesIpGroup
implements Serializable,
Cloneable,
StructuredPojo {
    private String groupId;
    private String groupName;
    private String groupDesc;
    private SdkInternalList<IpRuleItem> userRules;

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public WorkspacesIpGroup withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public WorkspacesIpGroup withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setGroupDesc(String groupDesc) {
        this.groupDesc = groupDesc;
    }

    public String getGroupDesc() {
        return this.groupDesc;
    }

    public WorkspacesIpGroup withGroupDesc(String groupDesc) {
        this.setGroupDesc(groupDesc);
        return this;
    }

    public List<IpRuleItem> getUserRules() {
        if (this.userRules == null) {
            this.userRules = new SdkInternalList();
        }
        return this.userRules;
    }

    public void setUserRules(Collection<IpRuleItem> userRules) {
        if (userRules == null) {
            this.userRules = null;
            return;
        }
        this.userRules = new SdkInternalList(userRules);
    }

    public WorkspacesIpGroup withUserRules(IpRuleItem ... userRules) {
        if (this.userRules == null) {
            this.setUserRules((Collection<IpRuleItem>)new SdkInternalList(userRules.length));
        }
        for (IpRuleItem ele : userRules) {
            this.userRules.add((Object)ele);
        }
        return this;
    }

    public WorkspacesIpGroup withUserRules(Collection<IpRuleItem> userRules) {
        this.setUserRules(userRules);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupId() != null) {
            sb.append("GroupId: ").append(this.getGroupId()).append(",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getGroupDesc() != null) {
            sb.append("GroupDesc: ").append(this.getGroupDesc()).append(",");
        }
        if (this.getUserRules() != null) {
            sb.append("UserRules: ").append(this.getUserRules());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspacesIpGroup)) {
            return false;
        }
        WorkspacesIpGroup other = (WorkspacesIpGroup)obj;
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getGroupDesc() == null ^ this.getGroupDesc() == null) {
            return false;
        }
        if (other.getGroupDesc() != null && !other.getGroupDesc().equals(this.getGroupDesc())) {
            return false;
        }
        if (other.getUserRules() == null ^ this.getUserRules() == null) {
            return false;
        }
        return other.getUserRules() == null || other.getUserRules().equals(this.getUserRules());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupDesc() == null ? 0 : this.getGroupDesc().hashCode());
        hashCode = 31 * hashCode + (this.getUserRules() == null ? 0 : this.getUserRules().hashCode());
        return hashCode;
    }

    public WorkspacesIpGroup clone() {
        try {
            return (WorkspacesIpGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        WorkspacesIpGroupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

