/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workspaces.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.workspaces.model.IpRuleItem;
import com.amazonaws.services.workspaces.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateIpGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String groupName;
    private String groupDesc;
    private SdkInternalList<IpRuleItem> userRules;
    private SdkInternalList<Tag> tags;

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public CreateIpGroupRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setGroupDesc(String groupDesc) {
        this.groupDesc = groupDesc;
    }

    public String getGroupDesc() {
        return this.groupDesc;
    }

    public CreateIpGroupRequest withGroupDesc(String groupDesc) {
        this.setGroupDesc(groupDesc);
        return this;
    }

    public List<IpRuleItem> getUserRules() {
        if (this.userRules == null) {
            this.userRules = new SdkInternalList();
        }
        return this.userRules;
    }

    public void setUserRules(Collection<IpRuleItem> userRules) {
        if (userRules == null) {
            this.userRules = null;
            return;
        }
        this.userRules = new SdkInternalList(userRules);
    }

    public CreateIpGroupRequest withUserRules(IpRuleItem ... userRules) {
        if (this.userRules == null) {
            this.setUserRules((Collection<IpRuleItem>)new SdkInternalList(userRules.length));
        }
        for (IpRuleItem ele : userRules) {
            this.userRules.add((Object)ele);
        }
        return this;
    }

    public CreateIpGroupRequest withUserRules(Collection<IpRuleItem> userRules) {
        this.setUserRules(userRules);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateIpGroupRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateIpGroupRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupName() != null) {
            sb.append("GroupName: ").append(this.getGroupName()).append(",");
        }
        if (this.getGroupDesc() != null) {
            sb.append("GroupDesc: ").append(this.getGroupDesc()).append(",");
        }
        if (this.getUserRules() != null) {
            sb.append("UserRules: ").append(this.getUserRules()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpGroupRequest)) {
            return false;
        }
        CreateIpGroupRequest other = (CreateIpGroupRequest)obj;
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getGroupDesc() == null ^ this.getGroupDesc() == null) {
            return false;
        }
        if (other.getGroupDesc() != null && !other.getGroupDesc().equals(this.getGroupDesc())) {
            return false;
        }
        if (other.getUserRules() == null ^ this.getUserRules() == null) {
            return false;
        }
        if (other.getUserRules() != null && !other.getUserRules().equals(this.getUserRules())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupDesc() == null ? 0 : this.getGroupDesc().hashCode());
        hashCode = 31 * hashCode + (this.getUserRules() == null ? 0 : this.getUserRules().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateIpGroupRequest clone() {
        return (CreateIpGroupRequest)super.clone();
    }
}

