/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamingDistributionConfig {
    private S3Origin s3Origin;
    private String callerReference;
    private List<String> cNAME;
    private String comment;
    private Boolean enabled;
    private LoggingConfig logging;
    private TrustedSigners trustedSigners;

    public StreamingDistributionConfig() {
    }

    public StreamingDistributionConfig(S3Origin s3Origin, String callerReference, Boolean enabled) {
        this.s3Origin = s3Origin;
        this.callerReference = callerReference;
        this.enabled = enabled;
    }

    public S3Origin getS3Origin() {
        return this.s3Origin;
    }

    public void setS3Origin(S3Origin s3Origin) {
        this.s3Origin = s3Origin;
    }

    public StreamingDistributionConfig withS3Origin(S3Origin s3Origin) {
        this.s3Origin = s3Origin;
        return this;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public void setCallerReference(String callerReference) {
        this.callerReference = callerReference;
    }

    public StreamingDistributionConfig withCallerReference(String callerReference) {
        this.callerReference = callerReference;
        return this;
    }

    public List<String> getCNAME() {
        if (this.cNAME == null) {
            this.cNAME = new ArrayList<String>();
        }
        return this.cNAME;
    }

    public void setCNAME(Collection<String> cNAME) {
        ArrayList<String> cNAMECopy = new ArrayList<String>();
        if (cNAME != null) {
            cNAMECopy.addAll(cNAME);
        }
        this.cNAME = cNAMECopy;
    }

    public StreamingDistributionConfig withCNAME(String ... cNAME) {
        if (this.getCNAME() == null) {
            this.setCNAME(new ArrayList<String>());
        }
        for (String value : cNAME) {
            this.getCNAME().add(value);
        }
        return this;
    }

    public StreamingDistributionConfig withCNAME(Collection<String> cNAME) {
        ArrayList<String> cNAMECopy = new ArrayList<String>();
        if (cNAME != null) {
            cNAMECopy.addAll(cNAME);
        }
        this.cNAME = cNAMECopy;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public StreamingDistributionConfig withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public StreamingDistributionConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public LoggingConfig getLogging() {
        return this.logging;
    }

    public void setLogging(LoggingConfig logging) {
        this.logging = logging;
    }

    public StreamingDistributionConfig withLogging(LoggingConfig logging) {
        this.logging = logging;
        return this;
    }

    public TrustedSigners getTrustedSigners() {
        return this.trustedSigners;
    }

    public void setTrustedSigners(TrustedSigners trustedSigners) {
        this.trustedSigners = trustedSigners;
    }

    public StreamingDistributionConfig withTrustedSigners(TrustedSigners trustedSigners) {
        this.trustedSigners = trustedSigners;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("S3Origin: " + this.s3Origin + ", ");
        sb.append("CallerReference: " + this.callerReference + ", ");
        sb.append("CNAME: " + this.cNAME + ", ");
        sb.append("Comment: " + this.comment + ", ");
        sb.append("Enabled: " + this.enabled + ", ");
        sb.append("Logging: " + this.logging + ", ");
        sb.append("TrustedSigners: " + this.trustedSigners + ", ");
        sb.append("}");
        return sb.toString();
    }
}

