/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.elasticache.AmazonElastiCacheAsync;
import com.amazonaws.services.elasticache.AmazonElastiCacheClient;
import com.amazonaws.services.elasticache.model.AuthorizeCacheSecurityGroupIngressRequest;
import com.amazonaws.services.elasticache.model.CacheCluster;
import com.amazonaws.services.elasticache.model.CacheParameterGroup;
import com.amazonaws.services.elasticache.model.CacheSecurityGroup;
import com.amazonaws.services.elasticache.model.CreateCacheClusterRequest;
import com.amazonaws.services.elasticache.model.CreateCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.CreateCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheClusterRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.DeleteCacheSecurityGroupRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParameterGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheParametersResult;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsRequest;
import com.amazonaws.services.elasticache.model.DescribeCacheSecurityGroupsResult;
import com.amazonaws.services.elasticache.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsRequest;
import com.amazonaws.services.elasticache.model.DescribeEventsResult;
import com.amazonaws.services.elasticache.model.EngineDefaults;
import com.amazonaws.services.elasticache.model.ModifyCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ModifyCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.RebootCacheClusterRequest;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupRequest;
import com.amazonaws.services.elasticache.model.ResetCacheParameterGroupResult;
import com.amazonaws.services.elasticache.model.RevokeCacheSecurityGroupIngressRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElastiCacheAsyncClient
extends AmazonElastiCacheClient
implements AmazonElastiCacheAsync {
    private ExecutorService executorService;

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonElastiCacheAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonElastiCacheAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<EngineDefaults> describeEngineDefaultParametersAsync(final DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<EngineDefaults>(){

            @Override
            public EngineDefaults call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeEngineDefaultParameters(describeEngineDefaultParametersRequest);
            }
        });
    }

    @Override
    public Future<ModifyCacheParameterGroupResult> modifyCacheParameterGroupAsync(final ModifyCacheParameterGroupRequest modifyCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ModifyCacheParameterGroupResult>(){

            @Override
            public ModifyCacheParameterGroupResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyCacheParameterGroup(modifyCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> createCacheClusterAsync(final CreateCacheClusterRequest createCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheCluster(createCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> authorizeCacheSecurityGroupIngressAsync(final AuthorizeCacheSecurityGroupIngressRequest authorizeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.authorizeCacheSecurityGroupIngress(authorizeCacheSecurityGroupIngressRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> createCacheSecurityGroupAsync(final CreateCacheSecurityGroupRequest createCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheSecurityGroup(createCacheSecurityGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> deleteCacheClusterAsync(final DeleteCacheClusterRequest deleteCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.deleteCacheCluster(deleteCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheSecurityGroupsResult> describeCacheSecurityGroupsAsync(final DescribeCacheSecurityGroupsRequest describeCacheSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheSecurityGroupsResult>(){

            @Override
            public DescribeCacheSecurityGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheSecurityGroups(describeCacheSecurityGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheParameterGroupsResult> describeCacheParameterGroupsAsync(final DescribeCacheParameterGroupsRequest describeCacheParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParameterGroupsResult>(){

            @Override
            public DescribeCacheParameterGroupsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheParameterGroups(describeCacheParameterGroupsRequest);
            }
        });
    }

    @Override
    public Future<DescribeCacheParametersResult> describeCacheParametersAsync(final DescribeCacheParametersRequest describeCacheParametersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheParametersResult>(){

            @Override
            public DescribeCacheParametersResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheParameters(describeCacheParametersRequest);
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeEvents(describeEventsRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> modifyCacheClusterAsync(final ModifyCacheClusterRequest modifyCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.modifyCacheCluster(modifyCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<ResetCacheParameterGroupResult> resetCacheParameterGroupAsync(final ResetCacheParameterGroupRequest resetCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<ResetCacheParameterGroupResult>(){

            @Override
            public ResetCacheParameterGroupResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.resetCacheParameterGroup(resetCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteCacheParameterGroupAsync(final DeleteCacheParameterGroupRequest deleteCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElastiCacheAsyncClient.this.deleteCacheParameterGroup(deleteCacheParameterGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<DescribeCacheClustersResult> describeCacheClustersAsync(final DescribeCacheClustersRequest describeCacheClustersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeCacheClustersResult>(){

            @Override
            public DescribeCacheClustersResult call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.describeCacheClusters(describeCacheClustersRequest);
            }
        });
    }

    @Override
    public Future<Void> deleteCacheSecurityGroupAsync(final DeleteCacheSecurityGroupRequest deleteCacheSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonElastiCacheAsyncClient.this.deleteCacheSecurityGroup(deleteCacheSecurityGroupRequest);
                return null;
            }
        });
    }

    @Override
    public Future<CacheParameterGroup> createCacheParameterGroupAsync(final CreateCacheParameterGroupRequest createCacheParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheParameterGroup>(){

            @Override
            public CacheParameterGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.createCacheParameterGroup(createCacheParameterGroupRequest);
            }
        });
    }

    @Override
    public Future<CacheCluster> rebootCacheClusterAsync(final RebootCacheClusterRequest rebootCacheClusterRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheCluster>(){

            @Override
            public CacheCluster call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.rebootCacheCluster(rebootCacheClusterRequest);
            }
        });
    }

    @Override
    public Future<CacheSecurityGroup> revokeCacheSecurityGroupIngressAsync(final RevokeCacheSecurityGroupIngressRequest revokeCacheSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<CacheSecurityGroup>(){

            @Override
            public CacheSecurityGroup call() throws Exception {
                return AmazonElastiCacheAsyncClient.this.revokeCacheSecurityGroupIngress(revokeCacheSecurityGroupIngressRequest);
            }
        });
    }
}

