/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.services.elasticache.model.CacheNode;
import com.amazonaws.services.elasticache.model.CacheParameterGroupStatus;
import com.amazonaws.services.elasticache.model.CacheSecurityGroupMembership;
import com.amazonaws.services.elasticache.model.NotificationConfiguration;
import com.amazonaws.services.elasticache.model.PendingModifiedValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheCluster {
    private String cacheClusterId;
    private String cacheNodeType;
    private String engine;
    private String engineVersion;
    private String cacheClusterStatus;
    private Integer numCacheNodes;
    private String preferredAvailabilityZone;
    private Date cacheClusterCreateTime;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private NotificationConfiguration notificationConfiguration;
    private List<CacheSecurityGroupMembership> cacheSecurityGroups;
    private CacheParameterGroupStatus cacheParameterGroup;
    private List<CacheNode> cacheNodes;
    private Boolean autoMinorVersionUpgrade;

    public String getCacheClusterId() {
        return this.cacheClusterId;
    }

    public void setCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
    }

    public CacheCluster withCacheClusterId(String cacheClusterId) {
        this.cacheClusterId = cacheClusterId;
        return this;
    }

    public String getCacheNodeType() {
        return this.cacheNodeType;
    }

    public void setCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
    }

    public CacheCluster withCacheNodeType(String cacheNodeType) {
        this.cacheNodeType = cacheNodeType;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public CacheCluster withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public CacheCluster withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public String getCacheClusterStatus() {
        return this.cacheClusterStatus;
    }

    public void setCacheClusterStatus(String cacheClusterStatus) {
        this.cacheClusterStatus = cacheClusterStatus;
    }

    public CacheCluster withCacheClusterStatus(String cacheClusterStatus) {
        this.cacheClusterStatus = cacheClusterStatus;
        return this;
    }

    public Integer getNumCacheNodes() {
        return this.numCacheNodes;
    }

    public void setNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
    }

    public CacheCluster withNumCacheNodes(Integer numCacheNodes) {
        this.numCacheNodes = numCacheNodes;
        return this;
    }

    public String getPreferredAvailabilityZone() {
        return this.preferredAvailabilityZone;
    }

    public void setPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
    }

    public CacheCluster withPreferredAvailabilityZone(String preferredAvailabilityZone) {
        this.preferredAvailabilityZone = preferredAvailabilityZone;
        return this;
    }

    public Date getCacheClusterCreateTime() {
        return this.cacheClusterCreateTime;
    }

    public void setCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
    }

    public CacheCluster withCacheClusterCreateTime(Date cacheClusterCreateTime) {
        this.cacheClusterCreateTime = cacheClusterCreateTime;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public CacheCluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public CacheCluster withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
        return this;
    }

    public NotificationConfiguration getNotificationConfiguration() {
        return this.notificationConfiguration;
    }

    public void setNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
    }

    public CacheCluster withNotificationConfiguration(NotificationConfiguration notificationConfiguration) {
        this.notificationConfiguration = notificationConfiguration;
        return this;
    }

    public List<CacheSecurityGroupMembership> getCacheSecurityGroups() {
        if (this.cacheSecurityGroups == null) {
            this.cacheSecurityGroups = new ArrayList<CacheSecurityGroupMembership>();
        }
        return this.cacheSecurityGroups;
    }

    public void setCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        ArrayList<CacheSecurityGroupMembership> cacheSecurityGroupsCopy = new ArrayList<CacheSecurityGroupMembership>();
        if (cacheSecurityGroups != null) {
            cacheSecurityGroupsCopy.addAll(cacheSecurityGroups);
        }
        this.cacheSecurityGroups = cacheSecurityGroupsCopy;
    }

    public CacheCluster withCacheSecurityGroups(CacheSecurityGroupMembership ... cacheSecurityGroups) {
        if (this.getCacheSecurityGroups() == null) {
            this.setCacheSecurityGroups(new ArrayList<CacheSecurityGroupMembership>());
        }
        for (CacheSecurityGroupMembership value : cacheSecurityGroups) {
            this.getCacheSecurityGroups().add(value);
        }
        return this;
    }

    public CacheCluster withCacheSecurityGroups(Collection<CacheSecurityGroupMembership> cacheSecurityGroups) {
        ArrayList<CacheSecurityGroupMembership> cacheSecurityGroupsCopy = new ArrayList<CacheSecurityGroupMembership>();
        if (cacheSecurityGroups != null) {
            cacheSecurityGroupsCopy.addAll(cacheSecurityGroups);
        }
        this.cacheSecurityGroups = cacheSecurityGroupsCopy;
        return this;
    }

    public CacheParameterGroupStatus getCacheParameterGroup() {
        return this.cacheParameterGroup;
    }

    public void setCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.cacheParameterGroup = cacheParameterGroup;
    }

    public CacheCluster withCacheParameterGroup(CacheParameterGroupStatus cacheParameterGroup) {
        this.cacheParameterGroup = cacheParameterGroup;
        return this;
    }

    public List<CacheNode> getCacheNodes() {
        if (this.cacheNodes == null) {
            this.cacheNodes = new ArrayList<CacheNode>();
        }
        return this.cacheNodes;
    }

    public void setCacheNodes(Collection<CacheNode> cacheNodes) {
        ArrayList<CacheNode> cacheNodesCopy = new ArrayList<CacheNode>();
        if (cacheNodes != null) {
            cacheNodesCopy.addAll(cacheNodes);
        }
        this.cacheNodes = cacheNodesCopy;
    }

    public CacheCluster withCacheNodes(CacheNode ... cacheNodes) {
        if (this.getCacheNodes() == null) {
            this.setCacheNodes(new ArrayList<CacheNode>());
        }
        for (CacheNode value : cacheNodes) {
            this.getCacheNodes().add(value);
        }
        return this;
    }

    public CacheCluster withCacheNodes(Collection<CacheNode> cacheNodes) {
        ArrayList<CacheNode> cacheNodesCopy = new ArrayList<CacheNode>();
        if (cacheNodes != null) {
            cacheNodesCopy.addAll(cacheNodes);
        }
        this.cacheNodes = cacheNodesCopy;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public CacheCluster withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("CacheClusterId: " + this.cacheClusterId + ", ");
        sb.append("CacheNodeType: " + this.cacheNodeType + ", ");
        sb.append("Engine: " + this.engine + ", ");
        sb.append("EngineVersion: " + this.engineVersion + ", ");
        sb.append("CacheClusterStatus: " + this.cacheClusterStatus + ", ");
        sb.append("NumCacheNodes: " + this.numCacheNodes + ", ");
        sb.append("PreferredAvailabilityZone: " + this.preferredAvailabilityZone + ", ");
        sb.append("CacheClusterCreateTime: " + this.cacheClusterCreateTime + ", ");
        sb.append("PreferredMaintenanceWindow: " + this.preferredMaintenanceWindow + ", ");
        sb.append("PendingModifiedValues: " + this.pendingModifiedValues + ", ");
        sb.append("NotificationConfiguration: " + this.notificationConfiguration + ", ");
        sb.append("CacheSecurityGroups: " + this.cacheSecurityGroups + ", ");
        sb.append("CacheParameterGroup: " + this.cacheParameterGroup + ", ");
        sb.append("CacheNodes: " + this.cacheNodes + ", ");
        sb.append("AutoMinorVersionUpgrade: " + this.autoMinorVersionUpgrade + ", ");
        sb.append("}");
        return sb.toString();
    }
}

