/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.OptionSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateConfigurationTemplateRequest
extends AmazonWebServiceRequest {
    private String applicationName;
    private String templateName;
    private String description;
    private List<ConfigurationOptionSetting> optionSettings;
    private List<OptionSpecification> optionsToRemove;

    public UpdateConfigurationTemplateRequest() {
    }

    public UpdateConfigurationTemplateRequest(String applicationName, String templateName) {
        this.applicationName = applicationName;
        this.templateName = templateName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public UpdateConfigurationTemplateRequest withApplicationName(String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public UpdateConfigurationTemplateRequest withTemplateName(String templateName) {
        this.templateName = templateName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateConfigurationTemplateRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<ConfigurationOptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new ArrayList<ConfigurationOptionSetting>();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>();
        if (optionSettings != null) {
            optionSettingsCopy.addAll(optionSettings);
        }
        this.optionSettings = optionSettingsCopy;
    }

    public UpdateConfigurationTemplateRequest withOptionSettings(ConfigurationOptionSetting ... optionSettings) {
        if (this.getOptionSettings() == null) {
            this.setOptionSettings(new ArrayList<ConfigurationOptionSetting>());
        }
        for (ConfigurationOptionSetting value : optionSettings) {
            this.getOptionSettings().add(value);
        }
        return this;
    }

    public UpdateConfigurationTemplateRequest withOptionSettings(Collection<ConfigurationOptionSetting> optionSettings) {
        ArrayList<ConfigurationOptionSetting> optionSettingsCopy = new ArrayList<ConfigurationOptionSetting>();
        if (optionSettings != null) {
            optionSettingsCopy.addAll(optionSettings);
        }
        this.optionSettings = optionSettingsCopy;
        return this;
    }

    public List<OptionSpecification> getOptionsToRemove() {
        if (this.optionsToRemove == null) {
            this.optionsToRemove = new ArrayList<OptionSpecification>();
        }
        return this.optionsToRemove;
    }

    public void setOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        ArrayList<OptionSpecification> optionsToRemoveCopy = new ArrayList<OptionSpecification>();
        if (optionsToRemove != null) {
            optionsToRemoveCopy.addAll(optionsToRemove);
        }
        this.optionsToRemove = optionsToRemoveCopy;
    }

    public UpdateConfigurationTemplateRequest withOptionsToRemove(OptionSpecification ... optionsToRemove) {
        if (this.getOptionsToRemove() == null) {
            this.setOptionsToRemove(new ArrayList<OptionSpecification>());
        }
        for (OptionSpecification value : optionsToRemove) {
            this.getOptionsToRemove().add(value);
        }
        return this;
    }

    public UpdateConfigurationTemplateRequest withOptionsToRemove(Collection<OptionSpecification> optionsToRemove) {
        ArrayList<OptionSpecification> optionsToRemoveCopy = new ArrayList<OptionSpecification>();
        if (optionsToRemove != null) {
            optionsToRemoveCopy.addAll(optionsToRemove);
        }
        this.optionsToRemove = optionsToRemoveCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ApplicationName: " + this.applicationName + ", ");
        sb.append("TemplateName: " + this.templateName + ", ");
        sb.append("Description: " + this.description + ", ");
        sb.append("OptionSettings: " + this.optionSettings + ", ");
        sb.append("OptionsToRemove: " + this.optionsToRemove + ", ");
        sb.append("}");
        return sb.toString();
    }
}

