/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.util.HashMap;
import java.util.Map;

public class TimingInfo {
    private final long startTime;
    private long endTime;
    private Map<String, TimingInfo> subMeasurementsByName = new HashMap<String, TimingInfo>();
    private Map<String, Number> countersByName = new HashMap<String, Number>();

    public TimingInfo() {
        this(System.currentTimeMillis(), -1L);
    }

    public TimingInfo(long startTime) {
        this(startTime, -1L);
    }

    public TimingInfo(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void addSubMeasurement(String subMeasurementName, TimingInfo timingInfo) {
        this.subMeasurementsByName.put(subMeasurementName, timingInfo);
    }

    public TimingInfo getSubMeasurement(String subMeasurementName) {
        return this.subMeasurementsByName.get(subMeasurementName);
    }

    public void addCounter(String key, Number value) {
        this.countersByName.put(key, value);
    }

    public Number getCounter(String key) {
        return this.countersByName.get(key);
    }
}

