/*
 * Copyright 2010-2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.support.model.transform;

import java.util.Map;
import java.util.Map.Entry;

import com.amazonaws.services.support.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;


/**
 * Trusted Advisor Check Description JSON Unmarshaller
 */
public class TrustedAdvisorCheckDescriptionJsonUnmarshaller implements Unmarshaller<TrustedAdvisorCheckDescription, JsonUnmarshallerContext> {

    

    public TrustedAdvisorCheckDescription unmarshall(JsonUnmarshallerContext context) throws Exception {
        TrustedAdvisorCheckDescription trustedAdvisorCheckDescription = new TrustedAdvisorCheckDescription();

        
        
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.currentToken;
        if (token == null) token = context.nextToken();

        while (true) {
            if (token == null) break;

            
            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("id", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckDescription.setId(StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("name", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckDescription.setName(StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckDescription.setDescription(StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("category", targetDepth)) {
                    context.nextToken();
                    trustedAdvisorCheckDescription.setCategory(StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("metadata", targetDepth)) {
                    trustedAdvisorCheckDescription.setMetadata(new ListUnmarshaller<String>(StringJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth) break;
                }
            }
            

            token = context.nextToken();
        }
        
        return trustedAdvisorCheckDescription;
    }

    private static TrustedAdvisorCheckDescriptionJsonUnmarshaller instance;
    public static TrustedAdvisorCheckDescriptionJsonUnmarshaller getInstance() {
        if (instance == null) instance = new TrustedAdvisorCheckDescriptionJsonUnmarshaller();
        return instance;
    }
}
    