/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.AWSXRayRecorderBuilder;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceID;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class AWSXRay {
    private static AWSXRayRecorder globalRecorder = AWSXRayRecorderBuilder.defaultRecorder();

    public static AWSXRayRecorder getGlobalRecorder() {
        return globalRecorder;
    }

    public static void setGlobalRecorder(AWSXRayRecorder globalRecorder) {
        AWSXRay.globalRecorder = globalRecorder;
    }

    public static <R> R createSegment(String name, Function<Segment, R> function) {
        return globalRecorder.createSegment(name, function);
    }

    public static void createSegment(String name, Consumer<Segment> consumer) {
        globalRecorder.createSegment(name, consumer);
    }

    public static <R> R createSegment(String name, Supplier<R> supplier) {
        return globalRecorder.createSegment(name, supplier);
    }

    public static void createSegment(String name, Runnable runnable) {
        globalRecorder.createSegment(name, runnable);
    }

    public static <R> R createSubsegment(String name, Function<Subsegment, R> function) {
        return globalRecorder.createSubsegment(name, function);
    }

    public static void createSubsegment(String name, Consumer<Subsegment> consumer) {
        globalRecorder.createSubsegment(name, consumer);
    }

    public static <R> R createSubsegment(String name, Supplier<R> supplier) {
        return globalRecorder.createSubsegment(name, supplier);
    }

    public static void createSubsegment(String name, Runnable runnable) {
        globalRecorder.createSubsegment(name, runnable);
    }

    public static Segment beginSegment(String name) {
        return globalRecorder.beginSegment(name);
    }

    public static Segment beginSegment(String name, TraceID traceId, String parentId) {
        return globalRecorder.beginSegment(name, traceId, parentId);
    }

    public static Segment beginDummySegment() {
        return globalRecorder.beginDummySegment();
    }

    public static void endSegment() {
        globalRecorder.endSegment();
    }

    public static Subsegment beginSubsegment(String name) {
        return globalRecorder.beginSubsegment(name);
    }

    public static void endSubsegment() {
        globalRecorder.endSubsegment();
    }

    public String currentEntityId() {
        return globalRecorder.currentEntityId();
    }

    public TraceID currentTraceId() {
        return globalRecorder.currentTraceId();
    }

    public static Segment getCurrentSegment() {
        return globalRecorder.getCurrentSegment();
    }

    public static Optional<Segment> getCurrentSegmentOptional() {
        return globalRecorder.getCurrentSegmentOptional();
    }

    public static Subsegment getCurrentSubsegment() {
        return globalRecorder.getCurrentSubsegment();
    }

    public static Optional<Subsegment> getCurrentSubsegmentOptional() {
        return globalRecorder.getCurrentSubsegmentOptional();
    }

    public static void injectThreadLocal(Entity entity) {
        globalRecorder.injectThreadLocal(entity);
    }

    public static Entity getThreadLocal() {
        return globalRecorder.getThreadLocal();
    }

    public static void clearThreadLocal() {
        globalRecorder.clearThreadLocal();
    }

    public static boolean sendSegment(Segment segment) {
        return globalRecorder.sendSegment(segment);
    }
}

