/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.AWSXRayRecorderBuilder;
import com.amazonaws.xray.ThreadLocalStorage;
import com.amazonaws.xray.emitters.DefaultEmitter;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.DummySegment;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.SegmentImpl;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.SubsegmentImpl;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.exceptions.SegmentNotFoundException;
import com.amazonaws.xray.exceptions.SubsegmentNotFoundException;
import com.amazonaws.xray.strategy.ContextMissingStrategy;
import com.amazonaws.xray.strategy.DefaultContextMissingStrategy;
import com.amazonaws.xray.strategy.DefaultPrioritizationStrategy;
import com.amazonaws.xray.strategy.DefaultStreamingStrategy;
import com.amazonaws.xray.strategy.DefaultThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.PrioritizationStrategy;
import com.amazonaws.xray.strategy.StreamingStrategy;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.sampling.DefaultSamplingStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSXRayRecorder {
    private static final Log logger = LogFactory.getLog(AWSXRayRecorder.class);
    private static final String PROPERTIES_LOCATION = "/com/amazonaws/xray/sdk.properties";
    private static final String SDK_VERSION_KEY = "awsxrayrecordersdk.version";
    private static final String DEFAULT_SDK_VERSION = "unknown";
    private static final String SDK = "X-Ray for Java";
    private static Map<String, Object> VERSION_INFORMATION = new HashMap<String, Object>();
    private SamplingStrategy samplingStrategy = new DefaultSamplingStrategy();
    private StreamingStrategy streamingStrategy = new DefaultStreamingStrategy();
    private PrioritizationStrategy prioritizationStrategy = new DefaultPrioritizationStrategy();
    private ThrowableSerializationStrategy throwableSerializationStrategy = new DefaultThrowableSerializationStrategy();
    private ContextMissingStrategy contextMissingStrategy = new DefaultContextMissingStrategy();
    private Emitter emitter;
    private Map<String, Object> runtimeContext;
    private String origin;

    public AWSXRayRecorder() {
        Optional<ContextMissingStrategy> environmentContextMissingStrategy = AWSXRayRecorderBuilder.contextMissingStrategyFromEnvironmentVariable();
        if (environmentContextMissingStrategy.isPresent()) {
            logger.info((Object)("Overriding contextMissingStrategy. Environment variable AWS_XRAY_CONTEXT_MISSING has value: \"" + System.getenv("AWS_XRAY_CONTEXT_MISSING") + "\"."));
            this.contextMissingStrategy = environmentContextMissingStrategy.get();
        }
        this.runtimeContext = new ConcurrentHashMap<String, Object>();
        this.runtimeContext.put("xray", VERSION_INFORMATION);
        try {
            this.emitter = new DefaultEmitter();
        }
        catch (SocketException e) {
            throw new RuntimeException("Unable to instantiate AWSXRayRecorder: ", e);
        }
    }

    public boolean sendSegment(Segment segment) {
        if (segment.isSampled()) {
            return this.emitter.sendSegment(segment);
        }
        return false;
    }

    public <R> R createSegment(String name, Function<Segment, R> function) {
        Segment segment = this.beginSegment(name);
        try {
            R r = function.apply(segment);
            return r;
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public void createSegment(String name, Consumer<Segment> consumer) {
        Segment segment = this.beginSegment(name);
        try {
            consumer.accept(segment);
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public <R> R createSegment(String name, Supplier<R> supplier) {
        Segment segment = this.beginSegment(name);
        try {
            R r = supplier.get();
            return r;
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public void createSegment(String name, Runnable runnable) {
        Segment segment = this.beginSegment(name);
        try {
            runnable.run();
        }
        catch (Exception e) {
            segment.addException(e);
            throw e;
        }
        finally {
            this.endSegment();
        }
    }

    public <R> R createSubsegment(String name, Function<Subsegment, R> function) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            R r = function.apply(subsegment);
            return r;
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public void createSubsegment(String name, Consumer<Subsegment> consumer) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            consumer.accept(subsegment);
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public <R> R createSubsegment(String name, Supplier<R> supplier) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            R r = supplier.get();
            return r;
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public void createSubsegment(String name, Runnable runnable) {
        Subsegment subsegment = this.beginSubsegment(name);
        try {
            runnable.run();
        }
        catch (Exception e) {
            subsegment.addException(e);
            throw e;
        }
        finally {
            this.endSubsegment();
        }
    }

    public Segment beginSegment(String name) {
        return this.beginSegment(new SegmentImpl(this, name));
    }

    public Segment beginSegment(String name, TraceID traceId, String parentId) {
        SegmentImpl segment = new SegmentImpl(this, name, traceId);
        segment.setParentId(parentId);
        return this.beginSegment(segment);
    }

    public Segment beginDummySegment() {
        return this.beginSegment(new DummySegment(this));
    }

    public Segment beginDummySegment(TraceID traceId) {
        return this.beginSegment(new DummySegment(this, traceId));
    }

    private Segment beginSegment(Segment segment) {
        if (ThreadLocalStorage.any()) {
            logger.error((Object)"Thread beginning new segment while another segment in progress. Overwriting current segment.");
        }
        segment.setAws(this.runtimeContext);
        if (null != this.getOrigin()) {
            segment.setOrigin(this.getOrigin());
        }
        ThreadLocalStorage.set(segment);
        return segment;
    }

    public void endSegment() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Ending segment.");
        }
        if (ThreadLocalStorage.any()) {
            Segment segment = ThreadLocalStorage.get().getParentSegment();
            if (segment.end()) {
                this.sendSegment(segment);
            }
            ThreadLocalStorage.clear();
        } else {
            this.contextMissingStrategy.contextMissing("Thread failed to end segment: segment cannot be found.", SegmentNotFoundException.class);
        }
    }

    public Subsegment beginSubsegment(String name) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Beginning subsegment: " + name));
        }
        if (ThreadLocalStorage.any()) {
            Segment parentSegment = ThreadLocalStorage.get().getParentSegment();
            SubsegmentImpl subsegment = new SubsegmentImpl(this, name, parentSegment);
            Entity parent = ThreadLocalStorage.get();
            subsegment.setParent(parent);
            parent.addSubsegment(subsegment);
            ThreadLocalStorage.set(subsegment);
            return subsegment;
        }
        this.contextMissingStrategy.contextMissing("Thread failed to begin a subsegment: segment cannot be found.", SegmentNotFoundException.class);
        return null;
    }

    public void endSubsegment() {
        if (logger.isDebugEnabled() && ThreadLocalStorage.any()) {
            logger.debug((Object)("Ending subsegment named: " + ThreadLocalStorage.get().getName()));
        }
        if (ThreadLocalStorage.any()) {
            Entity current = ThreadLocalStorage.get();
            if (current instanceof Subsegment) {
                Subsegment currentSubsegment = (Subsegment)current;
                if (currentSubsegment.end()) {
                    this.sendSegment(currentSubsegment.getParentSegment());
                } else {
                    if (this.streamingStrategy.requiresStreaming(currentSubsegment.getParentSegment())) {
                        this.streamingStrategy.streamSome(currentSubsegment.getParentSegment(), this.emitter);
                    }
                    ThreadLocalStorage.set(current.getParent());
                }
            } else {
                this.contextMissingStrategy.contextMissing("Thread failed to end a subsegment: subsegment cannot be found.", SubsegmentNotFoundException.class);
            }
        } else {
            this.contextMissingStrategy.contextMissing("Thread failed to end a subsegment: segment cannot be found.", SegmentNotFoundException.class);
        }
    }

    public Segment getCurrentSegment() {
        Optional<Segment> segment = this.getCurrentSegmentOptional();
        if (segment.isPresent()) {
            return segment.get();
        }
        this.contextMissingStrategy.contextMissing("Thread has no segment in progress.", SegmentNotFoundException.class);
        return null;
    }

    public Optional<Segment> getCurrentSegmentOptional() {
        Entity current = ThreadLocalStorage.get();
        if (current instanceof Segment) {
            return Optional.of((Segment)current);
        }
        if (current instanceof Subsegment) {
            return Optional.of(((Subsegment)current).getParentSegment());
        }
        return Optional.empty();
    }

    public Subsegment getCurrentSubsegment() {
        Entity current = ThreadLocalStorage.get();
        if (null == current) {
            this.contextMissingStrategy.contextMissing("Thread has no segment in progress.", SegmentNotFoundException.class);
        } else {
            if (current instanceof Subsegment) {
                return (Subsegment)current;
            }
            this.contextMissingStrategy.contextMissing("Thread's segment has no subsegments in progress.", SubsegmentNotFoundException.class);
        }
        return null;
    }

    public Optional<Subsegment> getCurrentSubsegmentOptional() {
        Entity current = ThreadLocalStorage.get();
        if (current instanceof Subsegment) {
            return Optional.of((Subsegment)current);
        }
        return Optional.empty();
    }

    public void injectThreadLocal(Entity entity) {
        ThreadLocalStorage.set(entity);
    }

    public Entity getThreadLocal() {
        return ThreadLocalStorage.get();
    }

    public void clearThreadLocal() {
        ThreadLocalStorage.clear();
    }

    public void putRuntimeContext(String key, Object value) {
        if (null == value) {
            value = "";
        }
        this.runtimeContext.put(key, value);
    }

    public SamplingStrategy getSamplingStrategy() {
        return this.samplingStrategy;
    }

    public void setSamplingStrategy(SamplingStrategy samplingStrategy) {
        this.samplingStrategy = samplingStrategy;
    }

    public StreamingStrategy getStreamingStrategy() {
        return this.streamingStrategy;
    }

    public void setStreamingStrategy(StreamingStrategy streamingStrategy) {
        this.streamingStrategy = streamingStrategy;
    }

    public PrioritizationStrategy getPrioritizationStrategy() {
        return this.prioritizationStrategy;
    }

    public void setPrioritizationStrategy(PrioritizationStrategy prioritizationStrategy) {
        this.prioritizationStrategy = prioritizationStrategy;
    }

    public ThrowableSerializationStrategy getThrowableSerializationStrategy() {
        return this.throwableSerializationStrategy;
    }

    public void setThrowableSerializationStrategy(ThrowableSerializationStrategy throwableSerializationStrategy) {
        this.throwableSerializationStrategy = throwableSerializationStrategy;
    }

    public ContextMissingStrategy getContextMissingStrategy() {
        return this.contextMissingStrategy;
    }

    public void setContextMissingStrategy(ContextMissingStrategy contextMissingStrategy) {
        this.contextMissingStrategy = contextMissingStrategy;
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public boolean forceSamplingOfCurrentSegment() {
        Segment segment;
        if (this.samplingStrategy.isForcedSamplingSupported() && !(segment = this.getCurrentSegment()).isSampled()) {
            segment.setSampled(true);
            return true;
        }
        return false;
    }

    public String currentEntityId() {
        if (null != ThreadLocalStorage.get()) {
            return ThreadLocalStorage.get().getId();
        }
        this.contextMissingStrategy.contextMissing("Thread failed to get current entity ID: segment or subsegment cannot be found.", SegmentNotFoundException.class);
        return null;
    }

    public TraceID currentTraceId() {
        if (null != ThreadLocalStorage.get()) {
            return ThreadLocalStorage.get().getParentSegment().getTraceId();
        }
        this.contextMissingStrategy.contextMissing("Thread failed to get current trace ID: segment cannot be found.", SegmentNotFoundException.class);
        return null;
    }

    static {
        InputStream propertiesStream = AWSXRayRecorder.class.getResourceAsStream(PROPERTIES_LOCATION);
        Properties properties = new Properties();
        try {
            properties.load(propertiesStream);
        }
        catch (IOException | IllegalArgumentException e) {
            logger.warn((Object)"Unable to detect SDK version.", (Throwable)e);
        }
        String sdkVersion = DEFAULT_SDK_VERSION;
        if (null != properties.getProperty(SDK_VERSION_KEY)) {
            sdkVersion = properties.getProperty(SDK_VERSION_KEY);
        }
        VERSION_INFORMATION.put("sdk", SDK);
        VERSION_INFORMATION.put("sdk_version", sdkVersion);
        VERSION_INFORMATION.put("runtime_version", System.getProperty("java.version"));
        VERSION_INFORMATION.put("runtime", System.getProperty("java.vm.name"));
    }
}

