/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.emitters.DefaultEmitter;
import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.plugins.Plugin;
import com.amazonaws.xray.strategy.ContextMissingStrategy;
import com.amazonaws.xray.strategy.DefaultContextMissingStrategy;
import com.amazonaws.xray.strategy.DefaultPrioritizationStrategy;
import com.amazonaws.xray.strategy.DefaultStreamingStrategy;
import com.amazonaws.xray.strategy.DefaultThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.LogErrorContextMissingStrategy;
import com.amazonaws.xray.strategy.PrioritizationStrategy;
import com.amazonaws.xray.strategy.RuntimeErrorContextMissingStrategy;
import com.amazonaws.xray.strategy.StreamingStrategy;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import com.amazonaws.xray.strategy.sampling.DefaultSamplingStrategy;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AWSXRayRecorderBuilder {
    private static final Log logger = LogFactory.getLog(AWSXRayRecorderBuilder.class);
    private Collection<Plugin> plugins = new ArrayList<Plugin>();
    private SamplingStrategy samplingStrategy = new DefaultSamplingStrategy();
    private StreamingStrategy streamingStrategy = new DefaultStreamingStrategy();
    private PrioritizationStrategy prioritizationStrategy = new DefaultPrioritizationStrategy();
    private ThrowableSerializationStrategy throwableSerializationStrategy = new DefaultThrowableSerializationStrategy();
    private ContextMissingStrategy contextMissingStrategy = new DefaultContextMissingStrategy();
    private Emitter emitter;

    private AWSXRayRecorderBuilder() {
        try {
            this.emitter = new DefaultEmitter();
        }
        catch (SocketException e) {
            throw new RuntimeException("Unable to instantiate AWSXRayRecorderBuilder: ", e);
        }
    }

    public static Optional<ContextMissingStrategy> contextMissingStrategyFromEnvironmentVariable() {
        String contextMissingStrategyOverrideValue = System.getenv("AWS_XRAY_CONTEXT_MISSING");
        if (null != contextMissingStrategyOverrideValue) {
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("LOG_ERROR")) {
                return Optional.of(new LogErrorContextMissingStrategy());
            }
            if (contextMissingStrategyOverrideValue.equalsIgnoreCase("RUNTIME_ERROR")) {
                return Optional.of(new RuntimeErrorContextMissingStrategy());
            }
        }
        return Optional.empty();
    }

    public static AWSXRayRecorderBuilder standard() {
        return new AWSXRayRecorderBuilder();
    }

    public static AWSXRayRecorder defaultRecorder() {
        return AWSXRayRecorderBuilder.standard().build();
    }

    public AWSXRayRecorderBuilder withPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    public AWSXRayRecorderBuilder withSamplingStrategy(SamplingStrategy samplingStrategy) {
        this.samplingStrategy = samplingStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withStreamingStrategy(StreamingStrategy streamingStrategy) {
        this.streamingStrategy = streamingStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withPrioritizationStrategy(PrioritizationStrategy prioritizationStrategy) {
        this.prioritizationStrategy = prioritizationStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withThrowableSerializationStrategy(ThrowableSerializationStrategy throwableSerializationStrategy) {
        this.throwableSerializationStrategy = throwableSerializationStrategy;
        return this;
    }

    public AWSXRayRecorderBuilder withEmitter(Emitter emitter) {
        this.emitter = emitter;
        return this;
    }

    public AWSXRayRecorderBuilder withContextMissingStrategy(ContextMissingStrategy contextMissingStrategy) {
        this.contextMissingStrategy = contextMissingStrategy;
        return this;
    }

    public AWSXRayRecorder build() {
        AWSXRayRecorder client = new AWSXRayRecorder();
        Optional<ContextMissingStrategy> environmentContextMissingStrategy = AWSXRayRecorderBuilder.contextMissingStrategyFromEnvironmentVariable();
        if (environmentContextMissingStrategy.isPresent()) {
            logger.info((Object)("Overriding contextMissingStrategy. Environment variable AWS_XRAY_CONTEXT_MISSING has value: \"" + System.getenv("AWS_XRAY_CONTEXT_MISSING") + "\"."));
            this.contextMissingStrategy = environmentContextMissingStrategy.get();
        }
        client.setSamplingStrategy(this.samplingStrategy);
        client.setStreamingStrategy(this.streamingStrategy);
        client.setPrioritizationStrategy(this.prioritizationStrategy);
        client.setThrowableSerializationStrategy(this.throwableSerializationStrategy);
        client.setContextMissingStrategy(this.contextMissingStrategy);
        client.setEmitter(this.emitter);
        this.plugins.stream().filter(Objects::nonNull).forEach(plugin -> {
            Map<String, Object> runtimeContext = plugin.getRuntimeContext();
            if (!runtimeContext.isEmpty()) {
                client.putRuntimeContext(plugin.getServiceName(), runtimeContext);
                client.setOrigin(plugin.getOrigin());
            } else {
                logger.warn((Object)(plugin.getClass().getName() + " plugin returned empty runtime context data. The recorder will not be setting segment origin or runtime context values from this plugin."));
            }
        });
        return client;
    }
}

