/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.emitters;

import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.StringValidator;
import com.amazonaws.xray.entities.Subsegment;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPEmitter
extends Emitter {
    private static final Log logger = LogFactory.getLog(UDPEmitter.class);
    private static final int DEFAULT_PORT = 2000;
    private DatagramSocket daemonSocket;
    private InetSocketAddress address;
    private byte[] sendBuffer = new byte[262144];
    private static final String AGENT_ADDRESS_KEY = "AWS_XRAY_DAEMON_ADDRESS";

    public UDPEmitter() throws SocketException {
        try {
            this.daemonSocket = new DatagramSocket();
        }
        catch (SocketException e) {
            logger.error((Object)"Exception while instantiating daemon socket.", (Throwable)e);
            throw e;
        }
        this.address = new InetSocketAddress(InetAddress.getLoopbackAddress(), 2000);
        String envAddress = System.getenv(AGENT_ADDRESS_KEY);
        try {
            if (StringValidator.isNotNullOrBlank(envAddress)) {
                this.parseAndModifyDaemonAddress(envAddress);
                logger.info((Object)("AWS_XRAY_DAEMON_ADDRESS is set. Emitting to daemon on address " + this.address.toString()));
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            logger.error((Object)("Error switching to provided daemon address " + envAddress + " in environment variable " + AGENT_ADDRESS_KEY + ". Using loopback address by default."), (Throwable)e);
        }
    }

    public void setDaemonAddress(String socketAddress) {
        String envAddress = System.getenv(AGENT_ADDRESS_KEY);
        if (StringValidator.isNullOrBlank(envAddress)) {
            this.parseAndModifyDaemonAddress(socketAddress);
        } else {
            logger.info((Object)"Ignoring call to setDaemonAddress as AWS_XRAY_DAEMON_ADDRESS is set.");
        }
    }

    private void parseAndModifyDaemonAddress(String socketAddress) {
        int lastColonIndex = socketAddress.lastIndexOf(58);
        if (-1 == lastColonIndex) {
            throw new IllegalArgumentException("Invalid value for environment variable AWS_XRAY_DAEMON_ADDRESS. Value must be of form \"ip_address:port\".");
        }
        this.address = new InetSocketAddress(socketAddress.substring(0, lastColonIndex), Integer.parseInt(socketAddress.substring(lastColonIndex + 1, socketAddress.length())));
    }

    @Override
    public boolean sendSegment(Segment segment) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)segment.prettySerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + segment.serialize()).getBytes());
    }

    @Override
    public boolean sendSubsegment(Subsegment subsegment) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)subsegment.prettyStreamSerialize());
        }
        return this.sendData(("{\"format\": \"json\", \"version\": 1}\n" + subsegment.streamSerialize()).getBytes());
    }

    private boolean sendData(byte[] data) {
        logger.debug((Object)"building packet");
        DatagramPacket packet = new DatagramPacket(this.sendBuffer, 262144, this.address);
        packet.setData(data);
        try {
            this.daemonSocket.send(packet);
        }
        catch (IOException e) {
            logger.error((Object)"Exception while sending segment over UDP.", (Throwable)e);
            return false;
        }
        return true;
    }
}

