/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.EntityImpl;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.TraceID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SegmentImpl
extends EntityImpl
implements Segment {
    private static final Log logger = LogFactory.getLog(SegmentImpl.class);
    protected String resourceArn;
    protected String user;
    protected String origin;
    protected Map<String, Object> service;
    @JsonIgnore
    private boolean sampled;
    @JsonIgnore
    private LongAdder referenceCount;
    @JsonIgnore
    private LongAdder totalSize;

    private SegmentImpl() {
    }

    public SegmentImpl(AWSXRayRecorder creator, String name) {
        this(creator, name, new TraceID());
    }

    public SegmentImpl(AWSXRayRecorder creator, String name, TraceID traceId) {
        super(creator, name);
        this.setTraceId(traceId);
        this.service = new ConcurrentHashMap<String, Object>();
        this.sampled = true;
        this.referenceCount = new LongAdder();
        this.totalSize = new LongAdder();
    }

    @Override
    public boolean end() {
        this.setEndTime((double)Instant.now().toEpochMilli() / 1000.0);
        this.setInProgress(false);
        return this.referenceCount.intValue() <= 0;
    }

    @Override
    public void putService(String key, Object object) {
        this.service.put(key, object);
    }

    @Override
    public boolean isSampled() {
        return this.sampled;
    }

    @Override
    public void setSampled(boolean sampled) {
        this.sampled = sampled;
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount.intValue();
    }

    @Override
    public LongAdder getTotalSize() {
        return this.totalSize;
    }

    @Override
    public void incrementReferenceCount() {
        this.referenceCount.increment();
        this.totalSize.increment();
    }

    @Override
    public boolean decrementReferenceCount() {
        this.referenceCount.decrement();
        return !this.isInProgress() && this.referenceCount.intValue() <= 0;
    }

    @Override
    public String getResourceArn() {
        return this.resourceArn;
    }

    @Override
    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(String origin) {
        this.origin = origin;
    }

    @Override
    public Map<String, Object> getService() {
        return this.service;
    }

    @Override
    public Segment getParentSegment() {
        return this;
    }

    @Override
    public void close() {
        this.getCreator().endSegment();
    }
}

