/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.EntityImpl;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SubsegmentImpl
extends EntityImpl
implements Subsegment {
    private static final Log logger = LogFactory.getLog(SubsegmentImpl.class);
    private String namespace;
    private Segment parentSegment;
    private Set<String> precursorIds;

    private SubsegmentImpl() {
    }

    public SubsegmentImpl(AWSXRayRecorder creator, String name, Segment parentSegment) {
        super(creator, name);
        this.parentSegment = parentSegment;
        parentSegment.incrementReferenceCount();
        this.precursorIds = new HashSet<String>();
    }

    @Override
    public boolean end() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ending self. Parent segment named " + this.parentSegment.getName() + " has reference count " + this.parentSegment.getReferenceCount()));
        }
        this.setEndTime((double)Instant.now().toEpochMilli() / 1000.0);
        this.setInProgress(false);
        return this.parentSegment.decrementReferenceCount() && this.parentSegment.isSampled();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public Segment getParentSegment() {
        return this.parentSegment;
    }

    @Override
    public void setParentSegment(Segment parentSegment) {
        this.parentSegment = parentSegment;
    }

    @Override
    public void addPrecursorId(String precursorId) {
        this.precursorIds.add(precursorId);
    }

    @Override
    public Set<String> getPrecursorIds() {
        return this.precursorIds;
    }

    @Override
    public void setPrecursorIds(Set<String> precursorIds) {
        this.precursorIds = precursorIds;
    }

    private ObjectNode getStreamSerializeObjectNode() {
        ObjectNode obj = (ObjectNode)mapper.valueToTree((Object)this);
        obj.put("type", "subsegment");
        obj.put("parent_id", this.getParent().getId());
        obj.put("trace_id", this.parentSegment.getTraceId().toString());
        return obj;
    }

    @Override
    public String streamSerialize() {
        String ret = "";
        try {
            ret = mapper.writeValueAsString((Object)this.getStreamSerializeObjectNode());
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)"Exception while serializing entity.", (Throwable)jpe);
        }
        return ret;
    }

    @Override
    public String prettyStreamSerialize() {
        String ret = "";
        try {
            ret = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.getStreamSerializeObjectNode());
        }
        catch (JsonProcessingException jpe) {
            logger.error((Object)"Exception while serializing entity.", (Throwable)jpe);
        }
        return ret;
    }

    @Override
    public void close() {
        this.getCreator().endSubsegment();
    }
}

