/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.entities;

import com.amazonaws.xray.entities.StringValidator;
import com.amazonaws.xray.entities.TraceID;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TraceHeader {
    public static final String HEADER_KEY = "X-Amzn-Trace-Id";
    private static final Log logger = LogFactory.getLog(TraceHeader.class);
    private static final String DELIMITER = ";";
    private static final char EQUALS = '=';
    private static final String ROOT_PREFIX = "Root=";
    private static final String PARENT_PREFIX = "Parent=";
    private static final String SAMPLED_PREFIX = "Sampled=";
    private static final String SELF_PREFIX = "Self=";
    private TraceID rootTraceId;
    private String parentId;
    private SampleDecision sampled;
    private Map<String, String> additionalParams = new ConcurrentHashMap<String, String>();
    private static String MALFORMED_ERROR_MESSAGE = "Malformed TraceHeader String input.";

    public TraceHeader() {
        this(null, null, SampleDecision.UNKNOWN);
    }

    public TraceHeader(TraceID rootTraceId) {
        this(rootTraceId, null, SampleDecision.UNKNOWN);
    }

    public TraceHeader(TraceID rootTraceId, String parentId) {
        this(rootTraceId, parentId, SampleDecision.UNKNOWN);
    }

    public TraceHeader(TraceID rootTraceId, String parentId, SampleDecision sampled) {
        this.rootTraceId = rootTraceId;
        this.parentId = parentId;
        this.sampled = sampled;
        if (null == sampled) {
            throw new IllegalArgumentException("Sample decision can not be null.");
        }
    }

    public static TraceHeader fromString(String string) {
        String[] parts;
        TraceHeader traceHeader = new TraceHeader();
        for (String part : parts = string.split(DELIMITER)) {
            String trimmedPart = part.trim();
            String value = TraceHeader.valueFromKeyEqualsValue(trimmedPart);
            if (trimmedPart.startsWith(ROOT_PREFIX)) {
                traceHeader.setRootTraceId(TraceID.fromString(value));
                continue;
            }
            if (trimmedPart.startsWith(PARENT_PREFIX)) {
                traceHeader.setParentId(value);
                continue;
            }
            if (trimmedPart.startsWith(SAMPLED_PREFIX)) {
                traceHeader.setSampled(SampleDecision.fromString(trimmedPart));
                continue;
            }
            if (trimmedPart.startsWith(SELF_PREFIX)) continue;
            traceHeader.putAdditionalParam(TraceHeader.keyFromKeyEqualsValue(trimmedPart), value);
        }
        return traceHeader;
    }

    private static String keyFromKeyEqualsValue(String keyEqualsValue) {
        int equalsIndex = keyEqualsValue.indexOf(61);
        if (-1 != equalsIndex) {
            return keyEqualsValue.substring(0, equalsIndex);
        }
        logger.error((Object)MALFORMED_ERROR_MESSAGE);
        return null;
    }

    private static String valueFromKeyEqualsValue(String keyEqualsValue) {
        int equalsIndex = keyEqualsValue.indexOf(61);
        if (-1 != equalsIndex) {
            return keyEqualsValue.substring(equalsIndex + 1);
        }
        logger.error((Object)MALFORMED_ERROR_MESSAGE);
        return null;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>();
        if (null != this.rootTraceId) {
            parts.add(ROOT_PREFIX + this.rootTraceId);
        }
        if (StringValidator.isNotNullOrBlank(this.parentId)) {
            parts.add(PARENT_PREFIX + this.parentId);
        }
        if (null != this.sampled) {
            parts.add(this.sampled.toString());
        }
        this.additionalParams.forEach((key, value) -> parts.add(key + '=' + value));
        return String.join((CharSequence)DELIMITER, parts);
    }

    public TraceID getRootTraceId() {
        return this.rootTraceId;
    }

    public void setRootTraceId(TraceID rootTraceId) {
        this.rootTraceId = rootTraceId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public SampleDecision getSampled() {
        return this.sampled;
    }

    public void setSampled(SampleDecision sampled) {
        if (null == sampled) {
            throw new IllegalArgumentException("Sample decision can not be null. Please use SampleDecision.UNKNOWN instead.");
        }
        this.sampled = sampled;
    }

    public Map<String, String> getAdditionalParams() {
        return this.additionalParams;
    }

    public void setAdditionalParams(Map<String, String> additionalParams) {
        this.additionalParams = additionalParams;
    }

    public void putAdditionalParam(String key, String value) {
        this.additionalParams.put(key, value);
    }

    public static enum SampleDecision {
        SAMPLED("Sampled=1"),
        NOT_SAMPLED("Sampled=0"),
        UNKNOWN(""),
        REQUESTED("Sampled=?");

        private String value;

        private SampleDecision(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        public static SampleDecision fromString(String text) {
            if (null != text) {
                for (SampleDecision decision : SampleDecision.values()) {
                    if (!decision.toString().equalsIgnoreCase(text)) continue;
                    return decision;
                }
            }
            return null;
        }
    }
}

