/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy;

import com.amazonaws.xray.emitters.Emitter;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.strategy.StreamingStrategy;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultStreamingStrategy
implements StreamingStrategy {
    private static final Log logger = LogFactory.getLog(DefaultStreamingStrategy.class);
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 100;

    @Override
    public boolean requiresStreaming(Segment segment) {
        if (segment.isSampled()) {
            return segment.getTotalSize().intValue() > 100;
        }
        return false;
    }

    @Override
    public void streamSome(Entity entity, Emitter emitter) {
        if (entity.getSubsegmentsLock().tryLock()) {
            try {
                new ArrayList<Subsegment>(entity.getSubsegments()).forEach(subsegment -> {
                    List<Subsegment> list = subsegment.getSubsegments();
                    synchronized (list) {
                        if (subsegment.isInProgress() || !subsegment.getSubsegments().isEmpty()) {
                            this.streamSome((Entity)subsegment, emitter);
                        } else {
                            emitter.sendSubsegment((Subsegment)subsegment);
                            entity.getSubsegments().remove(subsegment);
                            entity.getParentSegment().getTotalSize().decrement();
                        }
                    }
                });
            }
            finally {
                entity.getSubsegmentsLock().unlock();
            }
        }
    }
}

