/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.ThrowableDescription;
import com.amazonaws.xray.strategy.ThrowableSerializationStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultThrowableSerializationStrategy
implements ThrowableSerializationStrategy {
    private static final Log logger = LogFactory.getLog(DefaultThrowableSerializationStrategy.class);
    private static final int DEFAULT_MAX_STACK_TRACE_LENGTH = 50;
    private static Set<Class<? extends Throwable>> DEFAULT_REMOTE_EXCEPTION_CLASSES = new HashSet<Class<? extends Throwable>>();
    private int maxStackTraceLength;
    private Set<Class<? extends Throwable>> remoteExceptionClasses = new HashSet<Class<? extends Throwable>>();

    public DefaultThrowableSerializationStrategy() {
        this(50);
    }

    public DefaultThrowableSerializationStrategy(int maxStackTraceLength) {
        this(maxStackTraceLength, DEFAULT_REMOTE_EXCEPTION_CLASSES);
    }

    public DefaultThrowableSerializationStrategy(int maxStackTraceLength, Set<Class<? extends Throwable>> remoteExceptionClasses) {
        this.maxStackTraceLength = maxStackTraceLength;
        this.remoteExceptionClasses = remoteExceptionClasses;
    }

    @Override
    public List<ThrowableDescription> describeInContext(Throwable throwable, List<Subsegment> subsegments) {
        ArrayList<ThrowableDescription> result = new ArrayList<ThrowableDescription>();
        ThrowableDescription descriptor = new ThrowableDescription();
        Optional<ThrowableDescription> exceptionReferenced = subsegments.parallelStream().flatMap(subsegment -> subsegment.getCause().getExceptions().stream()).filter(throwableDescriptor -> throwable.equals(throwableDescriptor.getThrowable())).findAny();
        if (exceptionReferenced.isPresent()) {
            descriptor.setCause(null == exceptionReferenced.get().getId() ? exceptionReferenced.get().getCause() : exceptionReferenced.get().getId());
            descriptor.setThrowable(throwable);
            result.add(descriptor);
            return result;
        }
        descriptor.setId(Entity.generateId());
        descriptor.setMessage(throwable.getMessage());
        descriptor.setType(throwable.getClass().getName());
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        if (stackTrace.length > this.maxStackTraceLength) {
            descriptor.setStack(Arrays.copyOfRange(stackTrace, 0, this.maxStackTraceLength));
            descriptor.setTruncated(stackTrace.length - this.maxStackTraceLength);
        } else {
            descriptor.setStack(stackTrace);
        }
        descriptor.setThrowable(throwable);
        boolean isRemote = this.remoteExceptionClasses.parallelStream().anyMatch(remoteExceptionClass -> remoteExceptionClass.isInstance(throwable));
        if (isRemote) {
            descriptor.setRemote(true);
        }
        result.add(descriptor);
        for (Throwable nextNode = throwable.getCause(); null != nextNode; nextNode = nextNode.getCause()) {
            exceptionReferenced = subsegments.parallelStream().flatMap(subsegment -> subsegment.getCause().getExceptions().stream()).filter(throwableDescriptor -> throwable.equals(throwableDescriptor.getThrowable())).findAny();
            if (exceptionReferenced.isPresent()) {
                descriptor.setCause(null == exceptionReferenced.get().getId() ? exceptionReferenced.get().getCause() : exceptionReferenced.get().getId());
            } else {
                String newId = Entity.generateId();
                descriptor.setCause(newId);
                descriptor = new ThrowableDescription();
                descriptor.setId(newId);
                descriptor.setMessage(throwable.getMessage());
                descriptor.setType(throwable.getClass().getName());
                StackTraceElement[] stackTrace2 = throwable.getStackTrace();
                if (stackTrace2.length > this.maxStackTraceLength) {
                    descriptor.setStack(Arrays.copyOfRange(stackTrace2, 0, this.maxStackTraceLength));
                    descriptor.setTruncated(stackTrace2.length - this.maxStackTraceLength);
                } else {
                    descriptor.setStack(stackTrace2);
                }
                descriptor.setThrowable(throwable);
                boolean isRemote2 = this.remoteExceptionClasses.parallelStream().anyMatch(remoteExceptionClass -> remoteExceptionClass.isInstance(throwable));
                if (isRemote2) {
                    descriptor.setRemote(true);
                }
            }
            result.add(descriptor);
        }
        return result;
    }

    public int getMaxStackTraceLength() {
        return this.maxStackTraceLength;
    }

    static {
        DEFAULT_REMOTE_EXCEPTION_CLASSES.add(AmazonServiceException.class);
    }
}

