/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling;

import com.amazonaws.xray.strategy.sampling.SamplingRule;
import com.amazonaws.xray.strategy.sampling.SamplingRuleManifest;
import com.amazonaws.xray.strategy.sampling.SamplingStrategy;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalizedSamplingStrategy
implements SamplingStrategy {
    private static final Log logger = LogFactory.getLog(LocalizedSamplingStrategy.class);
    private static final URL DEFAULT_RULES = LocalizedSamplingStrategy.class.getResource("/com/amazonaws/xray/strategy/sampling/DefaultSamplingRules.json");
    private List<SamplingRule> rules;
    private SamplingRule defaultRule;
    private ObjectMapper mapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(JsonParser.Feature.ALLOW_COMMENTS, true);

    public LocalizedSamplingStrategy() {
        this(DEFAULT_RULES);
    }

    public LocalizedSamplingStrategy(URL ruleLocation) {
        this.processRuleManifest(this.getRuleManifest(ruleLocation));
    }

    private SamplingRuleManifest getRuleManifest(URL ruleLocation) {
        if (null == ruleLocation) {
            logger.error((Object)("Unable to parse null URL. Falling back to default rule set: " + DEFAULT_RULES.getPath()));
            return this.getDefaultRuleManifest();
        }
        try {
            return (SamplingRuleManifest)this.mapper.readValue(ruleLocation, SamplingRuleManifest.class);
        }
        catch (IOException ioe) {
            logger.error((Object)("Unable to parse " + ruleLocation.getPath() + ". Falling back to default rule set: " + DEFAULT_RULES.getPath()), (Throwable)ioe);
            return this.getDefaultRuleManifest();
        }
    }

    private SamplingRuleManifest getDefaultRuleManifest() {
        try {
            return (SamplingRuleManifest)this.mapper.readValue(DEFAULT_RULES, SamplingRuleManifest.class);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to parse " + DEFAULT_RULES + ".", ioe);
        }
    }

    private void processRuleManifest(SamplingRuleManifest manifest) {
        if (null != manifest) {
            this.defaultRule = manifest.getDefaultRule();
            if (null != this.defaultRule) {
                if (null != this.defaultRule.getUrlPath() || null != this.defaultRule.getServiceName() || null != this.defaultRule.getHttpMethod() || manifest.getVersion() != 1) {
                    this.throwInvalidSamplingRuleManifestException("The default rule must not specify values for url_path, service_name, or http_method.");
                } else if (this.defaultRule.getFixedTarget() < 0 || this.defaultRule.getRate() < 0.0f) {
                    this.throwInvalidSamplingRuleManifestException("The default rule must specify non-negative values for fixed_target and rate.");
                } else if (manifest.getVersion() != 1) {
                    this.throwInvalidSamplingRuleManifestException("Manifest version: " + manifest.getVersion() + " is not supported.");
                }
                manifest.getRules().stream().forEach(rule -> {
                    if (null == rule.getUrlPath() || null == rule.getServiceName() || null == rule.getHttpMethod()) {
                        this.throwInvalidSamplingRuleManifestException("All rules must have values for url_path, service_name, and http_method.");
                    } else if (rule.getFixedTarget() < 0 || rule.getRate() < 0.0f) {
                        this.throwInvalidSamplingRuleManifestException("All rules must have non-negative values for fixed_target and rate.");
                    }
                });
                this.rules = manifest.getRules();
            } else {
                this.throwInvalidSamplingRuleManifestException("A default rule must be provided.");
            }
        }
    }

    private void throwInvalidSamplingRuleManifestException(String detail) {
        throw new RuntimeException("Invalid sampling rule manifest provided. " + detail);
    }

    @Override
    public boolean shouldTrace(String serviceName, String path, String method) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Determining shouldTrace decision for:\n\tserviceName: " + serviceName + "\n\tpath: " + path + "\n\tmethod: " + method));
        }
        SamplingRule firstApplicableRule = null;
        if (null != this.rules) {
            firstApplicableRule = this.rules.stream().filter(rule -> rule.appliesTo(serviceName, path, method)).findFirst().orElse(null);
        }
        return null == firstApplicableRule ? this.shouldTrace(this.defaultRule) : this.shouldTrace(firstApplicableRule);
    }

    private boolean shouldTrace(SamplingRule samplingRule) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Applicable sampling rule: " + samplingRule));
        }
        if (samplingRule.getReservoir().take()) {
            return true;
        }
        return ThreadLocalRandom.current().nextFloat() < samplingRule.getRate();
    }

    @Override
    public boolean isForcedSamplingSupported() {
        return false;
    }
}

