/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.strategy.sampling;

import java.time.Instant;
import java.util.concurrent.atomic.LongAdder;

public class Reservoir {
    private int tracesPerSecond;
    private LongAdder usedThisSecond = new LongAdder();
    private long thisSecond;

    public Reservoir() {
        this(0);
    }

    public Reservoir(int tracesPerSecond) {
        this.tracesPerSecond = tracesPerSecond;
    }

    public boolean take() {
        long now = Instant.now().getEpochSecond();
        if (now != this.thisSecond) {
            this.usedThisSecond.reset();
            this.thisSecond = now;
        }
        if (this.usedThisSecond.intValue() >= this.tracesPerSecond) {
            return false;
        }
        this.usedThisSecond.increment();
        return true;
    }

    public int getTracesPerSecond() {
        return this.tracesPerSecond;
    }
}

